/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.verificationcode;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxPackageVerificationCode;
import org.spdx.storage.IModelStore;
import org.spdx.utility.verificationcode.IFileChecksumGenerator;

public class VerificationCodeGenerator {
    private final IFileChecksumGenerator fileChecksumGenerator;

    public VerificationCodeGenerator(IFileChecksumGenerator fileChecksumGenerator) {
        this.fileChecksumGenerator = fileChecksumGenerator;
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(SpdxFile[] spdxFiles, String[] skippedFilePaths, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        if (spdxFiles == null) {
            return null;
        }
        TreeSet<String> skippedFilePathSet = new TreeSet<String>();
        if (skippedFilePaths != null) {
            for (String skippedFilePath : skippedFilePaths) {
                if (skippedFilePath == null) continue;
                skippedFilePathSet.add(skippedFilePath);
            }
        }
        ArrayList<String> fileChecksums = new ArrayList<String>();
        for (SpdxFile spdxFile : spdxFiles) {
            Optional name;
            if (spdxFile == null || !(name = spdxFile.getName()).isPresent() || skippedFilePathSet.contains(name.get())) continue;
            fileChecksums.add(spdxFile.getSha1());
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFilePathSet.toArray(new String[0]), modelStore, documentUri);
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, File[] skippedFiles, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, IOException, InvalidSPDXAnalysisException {
        TreeSet<String> skippedFilesPath = new TreeSet<String>();
        String rootOfDirectory = sourceDirectory.getAbsolutePath();
        int rootLen = rootOfDirectory.length() + 1;
        for (File skippedFile : skippedFiles) {
            String skippedPath = VerificationCodeGenerator.normalizeFilePath(skippedFile.getAbsolutePath().substring(rootLen));
            skippedFilesPath.add(skippedPath);
        }
        ArrayList<String> fileChecksums = new ArrayList<String>();
        this.collectFileData(rootOfDirectory, sourceDirectory, fileChecksums, skippedFilesPath);
        String[] skippedFileNames = new String[skippedFilesPath.size()];
        Iterator iter = skippedFilesPath.iterator();
        int i = 0;
        while (iter.hasNext()) {
            skippedFileNames[i++] = (String)iter.next();
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFileNames, modelStore, documentUri);
    }

    protected SpdxPackageVerificationCode generatePackageVerificationCode(List<String> fileChecksums, String[] skippedFilePaths, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        for (String fileChecksum : fileChecksums) {
            byte[] hashInput = fileChecksum.getBytes(StandardCharsets.UTF_8);
            verificationCodeDigest.update(hashInput);
        }
        String value = VerificationCodeGenerator.convertChecksumToString(verificationCodeDigest.digest());
        SpdxPackageVerificationCode retval = new SpdxPackageVerificationCode(modelStore, documentUri, modelStore.getNextId(IModelStore.IdType.Anonymous), null, true);
        retval.setValue(value);
        for (String skippedPath : skippedFilePaths) {
            retval.getExcludedFileNames().add(skippedPath);
        }
        return retval;
    }

    private void collectFileData(String prefixForRelative, File sourceDirectory, List<String> fileNameAndChecksums, Set<String> skippedFiles) throws IOException {
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        File[] filesAndDirs = sourceDirectory.listFiles();
        if (filesAndDirs == null) {
            return;
        }
        for (File filesAndDir : filesAndDirs) {
            if (filesAndDir.isDirectory()) {
                this.collectFileData(prefixForRelative, filesAndDir, fileNameAndChecksums, skippedFiles);
                continue;
            }
            String filePath = VerificationCodeGenerator.normalizeFilePath(filesAndDir.getAbsolutePath().substring(prefixForRelative.length() + 1));
            if (skippedFiles.contains(filePath)) continue;
            String checksumValue = this.fileChecksumGenerator.getFileChecksum(filesAndDir).toLowerCase();
            fileNameAndChecksums.add(checksumValue);
        }
    }

    public static String normalizeFilePath(String nonNormalizedFilePath) {
        String filePath = nonNormalizedFilePath.replace('\\', '/').trim();
        if (filePath.contains("../")) {
            String[] filePathParts = filePath.split("/");
            StringBuilder normalizedFilePath = new StringBuilder();
            for (int j = 0; j < filePathParts.length; ++j) {
                if (j + 1 < filePathParts.length && filePathParts[j + 1].equals("..") || filePathParts[j].equals("..")) continue;
                if (j > 0) {
                    normalizedFilePath.append('/');
                }
                normalizedFilePath.append(filePathParts[j]);
            }
            filePath = normalizedFilePath.toString();
        }
        filePath = !(filePath = filePath.replace("./", "")).isEmpty() && filePath.charAt(0) == '/' ? "." + filePath : "./" + filePath;
        return filePath;
    }

    private static String convertChecksumToString(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, IOException, InvalidSPDXAnalysisException {
        return this.generatePackageVerificationCode(sourceDirectory, new File[0], modelStore, documentUri);
    }
}

