/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.Collection;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.utility.compare.SpdxComparer;

public class SpdxLicenseDifference {
    private final String licenseText;
    private final String licenseNameA;
    private final String licenseNameB;
    private final boolean licenseNamesEqual;
    private final String IdA;
    private final String IdB;
    private final String commentA;
    private final String commentB;
    private final boolean commentsEqual;
    private final Collection<String> sourceUrlsA;
    private final Collection<String> sourceUrlsB;
    private final boolean sourceUrlsEqual;

    public String getLicenseText() {
        return this.licenseText;
    }

    public String getLicenseNameA() {
        return this.licenseNameA;
    }

    public String getLicenseNameB() {
        return this.licenseNameB;
    }

    public boolean isLicenseNamesEqual() {
        return this.licenseNamesEqual;
    }

    public String getIdA() {
        return this.IdA;
    }

    public String getIdB() {
        return this.IdB;
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public boolean isCommentsEqual() {
        return this.commentsEqual;
    }

    public Collection<String> getSourceUrlsA() {
        return this.sourceUrlsA;
    }

    public Collection<String> getSourceUrlsB() {
        return this.sourceUrlsB;
    }

    public boolean isSourceUrlsEqual() {
        return this.sourceUrlsEqual;
    }

    public SpdxLicenseDifference(ExtractedLicenseInfo licenseA, ExtractedLicenseInfo licenseB) throws InvalidSPDXAnalysisException {
        this.licenseText = licenseA.getExtractedText();
        this.licenseNameA = licenseA.getName();
        this.licenseNameB = licenseB.getName();
        this.licenseNamesEqual = SpdxComparer.stringsEqual(this.licenseNameA, this.licenseNameB);
        this.IdA = licenseA.getLicenseId();
        this.IdB = licenseB.getLicenseId();
        this.commentA = licenseA.getComment();
        this.commentB = licenseB.getComment();
        this.commentsEqual = SpdxComparer.stringsEqual(this.commentA, this.commentB);
        this.sourceUrlsA = licenseA.getSeeAlso();
        this.sourceUrlsB = licenseB.getSeeAlso();
        this.sourceUrlsEqual = SpdxComparer.stringCollectionsEqual(this.sourceUrlsA, this.sourceUrlsB);
    }
}

