/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ListedLicenses;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.DisjunctiveLicenseSet;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.LicenseSet;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ConjunctiveLicenseSet;
import org.spdx.library.model.v3_0_1.expandedlicensing.CustomLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.License;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseParserException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.LicenseTextHelper;
import org.spdx.licenseTemplate.LineColumn;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.utility.compare.CompareTemplateOutputHandler;
import org.spdx.utility.compare.FilterTemplateOutputHandler;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.TemplateRegexMatcher;

public class LicenseCompareHelper {
    static final Logger logger = LoggerFactory.getLogger(LicenseCompareHelper.class);
    protected static final Integer CROSS_REF_NUM_WORDS_MATCH = 80;
    protected static final Pattern REGEX_QUANTIFIER_PATTERN = Pattern.compile(".*\\.\\{(\\d+),(\\d+)}$");
    static final String START_COMMENT_CHAR_PATTERN = "(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"";

    public static String licenseUriToLicenseId(String objectUri) {
        if (objectUri.startsWith("http://spdx.org/licenses/")) {
            return objectUri.substring("http://spdx.org/licenses/".length());
        }
        if (objectUri.startsWith("https://spdx.org/licenses/")) {
            return objectUri.substring("https://spdx.org/licenses/".length());
        }
        return objectUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeCommentChars(String s) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            while (line != null) {
                line = line.replaceAll("(\\*/|-->|-}|\\*\\)|\\s\\*)\\s*$", "");
                line = line.replaceAll("^\\s*(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"", "");
                line = line.replaceAll("^\\s*<<beginOptional>>\\s*(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"", "<<beginOptional>>");
                sb.append(line);
                sb.append("\n");
                line = reader.readLine();
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.warn("IO error reading strings?!?", (Throwable)e);
            String string = s;
            return string;
        }
        finally {
            if (Objects.nonNull(reader)) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("IO error closing a string reader?!?", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String locateOriginalText(String fullLicenseText, int startToken, int endToken, Map<Integer, LineColumn> tokenToLocation, String[] tokens) {
        if (startToken > endToken) {
            return "";
        }
        LineColumn start = tokenToLocation.get(startToken);
        if (start == null) {
            return "";
        }
        LineColumn end = tokenToLocation.get(endToken);
        try (BufferedReader reader = new BufferedReader(new StringReader(fullLicenseText));){
            int currentLine;
            String line = reader.readLine();
            for (currentLine = 1; line != null && currentLine < start.getLine(); ++currentLine) {
                line = reader.readLine();
            }
            if (line == null) {
                String string = "";
                return string;
            }
            if (end == null) {
                StringBuilder sb = new StringBuilder(line.substring(start.getColumn()));
                ++currentLine;
                line = reader.readLine();
                while (true) {
                    if (line == null) {
                        String string = sb.toString();
                        return string;
                    }
                    sb.append(line);
                    ++currentLine;
                    line = reader.readLine();
                }
            }
            if (end.getLine() == currentLine) {
                String sb = line.substring(start.getColumn(), end.getColumn() + end.getLen());
                return sb;
            }
            StringBuilder sb = new StringBuilder(line.substring(start.getColumn()));
            ++currentLine;
            line = reader.readLine();
            while (line != null && currentLine < end.getLine()) {
                sb.append("\n");
                sb.append(line);
                ++currentLine;
                line = reader.readLine();
            }
            if (line != null && end.getColumn() + end.getLen() > 0) {
                sb.append("\n");
                sb.append(line, 0, end.getColumn() + end.getLen());
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder(tokens[startToken]);
            int i = startToken + 1;
            while (i <= endToken) {
                sb.append(' ');
                sb.append(tokens[i]);
                ++i;
            }
            return sb.toString();
        }
    }

    public static String getFirstLicenseToken(String text) {
        String textToTokenize = LicenseTextHelper.normalizeText((String)LicenseTextHelper.replaceMultWord((String)LicenseTextHelper.replaceSpaceComma((String)LicenseTextHelper.removeLineSeparators((String)LicenseCompareHelper.removeCommentChars(text))))).toLowerCase();
        Matcher m = LicenseTextHelper.TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            return m.group(1).trim();
        }
        return null;
    }

    public static boolean isSingleTokenString(String text) {
        if (text.contains("\n")) {
            return false;
        }
        Matcher m = LicenseTextHelper.TOKEN_SPLIT_PATTERN.matcher(text);
        boolean found = false;
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return true;
    }

    public static boolean isLicenseEqual(org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo license1, org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (license1 instanceof ConjunctiveLicenseSet) {
            if (!(license2 instanceof ConjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual(((ConjunctiveLicenseSet)license1).getMembers(), ((ConjunctiveLicenseSet)license2).getMembers(), xlationMap);
        }
        if (license1 instanceof org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet) {
            if (!(license2 instanceof org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual(((org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet)license1).getMembers(), ((org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet)license2).getMembers(), xlationMap);
        }
        if (license1 instanceof CustomLicense) {
            if (!(license2 instanceof CustomLicense)) {
                return false;
            }
            String licenseid1 = license1.getObjectUri();
            String licenseid2 = license2.getObjectUri();
            String xlatedLicenseId = xlationMap.get(licenseid1);
            if (xlatedLicenseId == null) {
                return false;
            }
            return xlatedLicenseId.equals(licenseid2);
        }
        return license1.equals((Object)license2);
    }

    private static boolean isLicenseSetsEqual(Collection<org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo> licenseInfos1, Collection<org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo> licenseInfos2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (licenseInfos1 == null) {
            return licenseInfos2 == null;
        }
        if (licenseInfos2 == null) {
            return false;
        }
        if (licenseInfos1.size() != licenseInfos2.size()) {
            return false;
        }
        for (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo ali1 : licenseInfos1) {
            boolean found = false;
            for (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo ali2 : licenseInfos2) {
                if (!LicenseCompareHelper.isLicenseEqual(ali1, ali2, xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static List<String> getNonOptionalLicenseText(String licenseTemplate, FilterTemplateOutputHandler.VarTextHandling varTextHandling) throws SpdxCompareException {
        return LicenseCompareHelper.getNonOptionalLicenseText(licenseTemplate, varTextHandling, FilterTemplateOutputHandler.OptionalTextHandling.OMIT);
    }

    public static List<String> getNonOptionalLicenseText(String licenseTemplate, FilterTemplateOutputHandler.VarTextHandling varTextHandling, FilterTemplateOutputHandler.OptionalTextHandling optionalTextHandling) throws SpdxCompareException {
        FilterTemplateOutputHandler filteredOutput = new FilterTemplateOutputHandler(varTextHandling, optionalTextHandling);
        try {
            SpdxLicenseTemplateHelper.parseTemplate((String)licenseTemplate, (ILicenseTemplateOutputHandler)filteredOutput);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during filter: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during filter: " + e.getMessage(), e);
        }
        return filteredOutput.getFilteredText();
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextMatchingTemplate(String template, String compareText) throws SpdxCompareException {
        CompareTemplateOutputHandler compareTemplateOutputHandler;
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(LicenseTextHelper.removeLineSeparators((String)LicenseCompareHelper.removeCommentChars(compareText)));
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate((String)LicenseCompareHelper.removeCommentChars(template), (ILicenseTemplateOutputHandler)compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardLicense(License license, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        String licenseTemplate = license.getStandardLicenseTemplate().orElse("");
        if (licenseTemplate.trim().isEmpty()) {
            licenseTemplate = license.getLicenseText();
        }
        return LicenseCompareHelper.isTextMatchingTemplate(licenseTemplate, compareText);
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardException(org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException exception, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        String exceptionTemplate = exception.getStandardAdditionTemplate().orElse("");
        if (exceptionTemplate.trim().isEmpty()) {
            exceptionTemplate = exception.getAdditionText();
        }
        return LicenseCompareHelper.isTextMatchingTemplate(exceptionTemplate, compareText);
    }

    public static boolean isStandardLicenseWithinText(String text, ListedLicense license) {
        try {
            return new TemplateRegexMatcher(license.getStandardLicenseTemplate().orElse(license.getLicenseText())).isTemplateMatchWithinText(text);
        }
        catch (SpdxCompareException e) {
            logger.warn("Compare error getting optional text for license {}", (Object)license.getObjectUri(), (Object)e);
            return false;
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("SPDX Analysis error getting optional text for license {}", (Object)license.getObjectUri(), (Object)e);
            return false;
        }
    }

    public static boolean isStandardLicenseExceptionWithinText(String text, org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException exception) {
        boolean result = false;
        if (text == null || text.isEmpty() || exception == null) {
            return false;
        }
        try {
            return new TemplateRegexMatcher(exception.getStandardAdditionTemplate().orElse(exception.getAdditionText())).isTemplateMatchWithinText(text);
        }
        catch (SpdxCompareException e) {
            logger.warn("Compare error getting optional text for license exception ID {}", (Object)exception.getObjectUri(), (Object)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("SPDX analysis error getting optional text for license exception ID {}", (Object)exception.getObjectUri(), (Object)e);
        }
        return result;
    }

    public static String[] matchingStandardLicenseIds(String licenseText) throws InvalidSPDXAnalysisException, SpdxCompareException {
        List<String> stdLicenseIds = ListedLicenses.getListedLicenses().getSpdxListedLicenseIds();
        ArrayList<String> matchingIds = new ArrayList<String>();
        for (String stdLicId : stdLicenseIds) {
            ListedLicense license = ListedLicenses.getListedLicenses().getListedLicenseById(stdLicId);
            if (LicenseCompareHelper.isTextStandardLicense((License)license, licenseText).isDifferenceFound()) continue;
            matchingIds.add(LicenseCompareHelper.licenseUriToLicenseId(license.getObjectUri()));
        }
        return matchingIds.toArray(new String[0]);
    }

    public static List<String> matchingStandardLicenseIdsWithinText(String text, List<String> licenseIds) throws InvalidSPDXAnalysisException {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null && !text.isEmpty() && licenseIds != null && !licenseIds.isEmpty()) {
            for (String stdLicId : licenseIds) {
                ListedLicense license = ListedLicenses.getListedLicenses().getListedLicenseById(stdLicId);
                if (!LicenseCompareHelper.isStandardLicenseWithinText(text, license)) continue;
                result.add(LicenseCompareHelper.licenseUriToLicenseId(license.getObjectUri()));
            }
        }
        return result;
    }

    public static List<String> matchingStandardLicenseIdsWithinText(String text) throws InvalidSPDXAnalysisException {
        return LicenseCompareHelper.matchingStandardLicenseIdsWithinText(text, ListedLicenses.getListedLicenses().getSpdxListedLicenseIds());
    }

    public static List<String> matchingStandardLicenseExceptionIdsWithinText(String text, List<String> licenseExceptionIds) throws InvalidSPDXAnalysisException {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null && !text.isEmpty() && licenseExceptionIds != null && !licenseExceptionIds.isEmpty()) {
            for (String stdLicExcId : licenseExceptionIds) {
                org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException licenseException = ListedLicenses.getListedLicenses().getListedExceptionById(stdLicExcId);
                if (!LicenseCompareHelper.isStandardLicenseExceptionWithinText(text, licenseException)) continue;
                result.add(LicenseCompareHelper.licenseUriToLicenseId(licenseException.getObjectUri()));
            }
        }
        return result;
    }

    public static List<String> matchingStandardLicenseExceptionIdsWithinText(String text) throws InvalidSPDXAnalysisException {
        return LicenseCompareHelper.matchingStandardLicenseExceptionIdsWithinText(text, ListedLicenses.getListedLicenses().getSpdxListedExceptionIds());
    }

    private static <T> boolean contains(T[] array, T value) {
        for (T t : array) {
            if (!Objects.equals(t, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLicensePassBlackList(org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo license, String ... blackList) {
        if (license == null) {
            return true;
        }
        if (blackList == null || blackList.length == 0) {
            return true;
        }
        if (license instanceof ConjunctiveLicenseSet) {
            for (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo member : ((ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet) {
            for (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo member : ((org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return true;
            }
            return false;
        }
        return !LicenseCompareHelper.contains(blackList, license.toString());
    }

    public static boolean isLicensePassWhiteList(org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo license, String ... whiteList) {
        if (license == null) {
            return false;
        }
        if (whiteList == null || whiteList.length == 0) {
            return false;
        }
        if (license instanceof ConjunctiveLicenseSet) {
            for (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo member : ((ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet) {
            for (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo member : ((org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return true;
            }
            return false;
        }
        return LicenseCompareHelper.contains(whiteList, license.toString());
    }

    public static boolean isLicenseEqual(AnyLicenseInfo license1, AnyLicenseInfo license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (license1 instanceof org.spdx.library.model.v2.license.ConjunctiveLicenseSet) {
            if (!(license2 instanceof org.spdx.library.model.v2.license.ConjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((LicenseSet)((org.spdx.library.model.v2.license.ConjunctiveLicenseSet)license1), (LicenseSet)((org.spdx.library.model.v2.license.ConjunctiveLicenseSet)license2), xlationMap);
        }
        if (license1 instanceof DisjunctiveLicenseSet) {
            if (!(license2 instanceof DisjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((LicenseSet)((DisjunctiveLicenseSet)license1), (LicenseSet)((DisjunctiveLicenseSet)license2), xlationMap);
        }
        if (license1 instanceof ExtractedLicenseInfo) {
            if (!(license2 instanceof ExtractedLicenseInfo)) {
                return false;
            }
            String licenseUri1 = license1.getObjectUri();
            String licenseUri2 = license2.getObjectUri();
            String xlatedLicenseId = xlationMap.get(licenseUri1);
            if (xlatedLicenseId == null) {
                return false;
            }
            return xlatedLicenseId.equals(licenseUri2);
        }
        return license1.equals((Object)license2);
    }

    private static boolean isLicenseSetsEqual(LicenseSet license1, LicenseSet license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Collection licenseInfos1 = license1.getMembers();
        Collection licenseInfos2 = license2.getMembers();
        if (licenseInfos1 == null) {
            return licenseInfos2 == null;
        }
        if (licenseInfos2 == null) {
            return false;
        }
        if (licenseInfos1.size() != licenseInfos2.size()) {
            return false;
        }
        for (AnyLicenseInfo ali1 : licenseInfos1) {
            boolean found = false;
            for (AnyLicenseInfo ali2 : licenseInfos2) {
                if (!LicenseCompareHelper.isLicenseEqual(ali1, ali2, xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardLicense(org.spdx.library.model.v2.license.License license, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        CompareTemplateOutputHandler compareTemplateOutputHandler;
        String licenseTemplate = license.getStandardLicenseTemplate();
        if (licenseTemplate == null || licenseTemplate.trim().isEmpty()) {
            licenseTemplate = license.getLicenseText();
        }
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(LicenseTextHelper.removeLineSeparators((String)LicenseCompareHelper.removeCommentChars(compareText)));
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate((String)LicenseCompareHelper.removeCommentChars(licenseTemplate), (ILicenseTemplateOutputHandler)compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardException(LicenseException exception, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        CompareTemplateOutputHandler compareTemplateOutputHandler;
        String exceptionTemplate = exception.getLicenseExceptionTemplate();
        if (exceptionTemplate == null || exceptionTemplate.trim().isEmpty()) {
            exceptionTemplate = exception.getLicenseExceptionText();
        }
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(LicenseTextHelper.removeLineSeparators((String)LicenseCompareHelper.removeCommentChars(compareText)));
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate((String)LicenseCompareHelper.removeCommentChars(exceptionTemplate), (ILicenseTemplateOutputHandler)compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static boolean isStandardLicenseWithinText(String text, SpdxListedLicense license) {
        try {
            return new TemplateRegexMatcher(license.getStandardLicenseTemplate()).isTemplateMatchWithinText(text);
        }
        catch (SpdxCompareException e) {
            logger.warn("Compare error getting optional text for license {}", (Object)license.getObjectUri(), (Object)e);
            return false;
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("SPDX error getting optional text for license {}", (Object)license.getObjectUri(), (Object)e);
            return false;
        }
    }

    public static boolean isStandardLicenseExceptionWithinText(String text, ListedLicenseException exception) {
        boolean result = false;
        if (text == null || text.isEmpty() || exception == null) {
            return false;
        }
        try {
            return new TemplateRegexMatcher(exception.getLicenseExceptionTemplate()).isTemplateMatchWithinText(text);
        }
        catch (SpdxCompareException e) {
            logger.warn("Compare error getting optional text for license exception ID {}", (Object)exception.getObjectUri(), (Object)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("SPDX error getting optional text for license exception ID {}", (Object)exception.getObjectUri(), (Object)e);
        }
        return result;
    }

    public static boolean isLicensePassBlackList(AnyLicenseInfo license, String ... blackList) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return true;
        }
        if (blackList == null || blackList.length == 0) {
            return true;
        }
        if (license instanceof org.spdx.library.model.v2.license.ConjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((org.spdx.library.model.v2.license.ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof DisjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return true;
            }
            return false;
        }
        return !LicenseCompareHelper.contains(blackList, license.toString());
    }

    public static boolean isLicensePassWhiteList(AnyLicenseInfo license, String ... whiteList) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return false;
        }
        if (whiteList == null || whiteList.length == 0) {
            return false;
        }
        if (license instanceof org.spdx.library.model.v2.license.ConjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((org.spdx.library.model.v2.license.ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof DisjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return true;
            }
            return false;
        }
        return LicenseCompareHelper.contains(whiteList, license.toString());
    }
}

