/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.TypedValue;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.IListedLicenseStore;

public class SpdxV3ListedLicenseModelStore
implements IModelStore {
    static Set<PropertyDescriptor> SUPPORTED_V3_DESCRIPTORS = new HashSet<PropertyDescriptor>();
    IListedLicenseStore baseStore;

    public SpdxV3ListedLicenseModelStore(IListedLicenseStore baseStore) {
        this.baseStore = baseStore;
    }

    public void close() throws Exception {
        this.baseStore.close();
    }

    public boolean exists(String objectUri) {
        return this.baseStore.exists(objectUri);
    }

    public void create(TypedValue typedValue) throws InvalidSPDXAnalysisException {
        if (!typedValue.getSpecVersion().startsWith("3.")) {
            throw new InvalidSPDXAnalysisException("Can not create an SPDX 2.X version using the SPDX V3 listed license model");
        }
        this.baseStore.create(typedValue);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String objectUri) throws InvalidSPDXAnalysisException {
        ArrayList<PropertyDescriptor> retval = new ArrayList<PropertyDescriptor>();
        this.baseStore.getPropertyValueDescriptors(objectUri).forEach(pd -> {
            if (SUPPORTED_V3_DESCRIPTORS.contains(pd)) {
                retval.add((PropertyDescriptor)pd);
            }
        });
        retval.add(SpdxConstantsV3.PROP_CREATION_INFO);
        return retval;
    }

    public void setValue(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        this.baseStore.setValue(objectUri, propertyDescriptor, value);
    }

    public Optional<Object> getValue(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.getValue(objectUri, propertyDescriptor);
    }

    public String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        return this.baseStore.getNextId(idType);
    }

    public void removeProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.baseStore.removeProperty(objectUri, propertyDescriptor);
    }

    public Stream<TypedValue> getAllItems(@Nullable String nameSpace, @Nullable String typeFilter) throws InvalidSPDXAnalysisException {
        return this.baseStore.getAllItems(nameSpace, typeFilter).filter(tv -> tv.getSpecVersion().startsWith("3."));
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) throws InvalidSPDXAnalysisException {
        return this.baseStore.enterCriticalSection(readLockRequested);
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        this.baseStore.leaveCriticalSection(lock);
    }

    public boolean removeValueFromCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.removeValueFromCollection(objectUri, propertyDescriptor, value);
    }

    public int collectionSize(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.collectionSize(objectUri, propertyDescriptor);
    }

    public boolean collectionContains(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.collectionContains(objectUri, propertyDescriptor, value);
    }

    public void clearValueCollection(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        this.baseStore.clearValueCollection(objectUri, propertyDescriptor);
    }

    public boolean addValueToCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.addValueToCollection(objectUri, propertyDescriptor, value);
    }

    public Iterator<Object> listValues(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.listValues(objectUri, propertyDescriptor);
    }

    public boolean isCollectionMembersAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.isCollectionMembersAssignableTo(objectUri, propertyDescriptor, clazz);
    }

    public boolean isPropertyValueAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.isPropertyValueAssignableTo(objectUri, propertyDescriptor, clazz, specVersion);
    }

    public boolean isCollectionProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if (!SUPPORTED_V3_DESCRIPTORS.contains(propertyDescriptor)) {
            throw new InvalidSPDXAnalysisException("Unsupported property for SPDX V3 Listed License or Exception " + propertyDescriptor.getName());
        }
        return this.baseStore.isCollectionProperty(objectUri, propertyDescriptor);
    }

    public IModelStore.IdType getIdType(String objectUri) {
        return this.baseStore.getIdType(objectUri);
    }

    public Optional<String> getCaseSensitiveId(String nameSpace, String caseInsensitiveId) {
        return this.baseStore.getCaseSensitiveId(nameSpace, caseInsensitiveId);
    }

    public Optional<TypedValue> getTypedValue(String objectUri) throws InvalidSPDXAnalysisException {
        Optional baseTypedValue = this.baseStore.getTypedValue(objectUri);
        if (!baseTypedValue.isPresent() || ((TypedValue)baseTypedValue.get()).getSpecVersion().startsWith("3.")) {
            return baseTypedValue;
        }
        switch (((TypedValue)baseTypedValue.get()).getType()) {
            case "ListedLicense": {
                return Optional.of(new TypedValue(objectUri, "ExpandedLicensing.ListedLicense", "3.0.1"));
            }
            case "ListedLicenseException": {
                return Optional.of(new TypedValue(objectUri, "ExpandedLicensing.ListedLicenseException", "3.0.1"));
            }
            case "Core.CreationInfo": {
                return Optional.of(new TypedValue(objectUri, "Core.CreationInfo", "3.0.1"));
            }
            case "Core.Agent": {
                return Optional.of(new TypedValue(objectUri, "Core.Agent", "3.0.1"));
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported type for SPDX V2 listed license model store: " + ((TypedValue)baseTypedValue.get()).getType());
    }

    public void delete(String objectUri) throws InvalidSPDXAnalysisException {
        this.baseStore.delete(objectUri);
    }

    public boolean isAnon(String objectUri) {
        return this.baseStore.isAnon(objectUri);
    }

    public CreationInfo getListedLicenseCreationInfo() throws InvalidSPDXAnalysisException {
        return this.baseStore.getListedLicenseCreationInfo();
    }

    static {
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_LICENSE_TEXT);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_NAME);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_CREATION_INFO);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_STANDARD_LICENSE_HEADER);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_IS_OSI_APPROVED);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_IS_FSF_LIBRE);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_IS_DEPRECATED_LICENSE_ID);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_DEPRECATED_VERSION);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_COMMENT);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_SEE_ALSO);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_STANDARD_LICENSE_TEMPLATE);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_LICENSE_XML);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_OBSOLETED_BY);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_LIST_VERSION_ADDED);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_ADDITION_TEXT);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_STANDARD_ADDITION_TEMPLATE);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_IS_DEPRECATED_ADDITION_ID);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_CREATED);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_CREATED_BY);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_SPEC_VERSION);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_DESCRIPTION);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_EXTERNAL_REF);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_VERIFIED_USING);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_EXTENSION);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_CREATED_USING);
        SUPPORTED_V3_DESCRIPTORS.add(SpdxConstantsV3.PROP_SUMMARY);
    }
}

