/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;
import org.spdx.utility.DownloadCache;

public class SpdxListedLicenseWebStore
extends SpdxListedLicenseModelStore {
    private InputStream getUrlInputStream(URL url) throws IOException {
        return DownloadCache.getInstance().getUrlInputStream(url);
    }

    @Override
    public InputStream getTocInputStream() throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/licenses.json"));
    }

    @Override
    public InputStream getLicenseInputStream(String licenseId) throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/" + licenseId + ".json"));
    }

    @Override
    public InputStream getExceptionTocInputStream() throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/exceptions.json"));
    }

    @Override
    public InputStream getExceptionInputStream(String exceptionId) throws IOException {
        return this.getLicenseInputStream(exceptionId);
    }
}

