/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.InvalidSpdxPropertyException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.CrossRefJson;

public class LicenseJson {
    static final Map<PropertyDescriptor, String> PROPERTY_DESCRIPTOR_TO_VALUE_NAME;
    static final List<PropertyDescriptor> ALL_PROPERTY_DESCRIPTORS;
    static final Set<PropertyDescriptor> COLLECTION_PROPERTIES;
    Boolean isDeprecatedLicenseId;
    Boolean isFsfLibre;
    String licenseText;
    String standardLicenseHeaderTemplate;
    String standardLicenseTemplate;
    String name;
    String licenseComments;
    String comment;
    String licenseId;
    String standardLicenseHeader;
    List<CrossRefJson> crossRef = new ArrayList<CrossRefJson>();
    List<String> seeAlso = new ArrayList<String>();
    Boolean isOsiApproved;
    String licenseTextHtml;
    String standardLicenseHeaderHtml;
    String example;
    String deprecatedVersion;
    String obsoletedBy;
    String licenseXml;
    String listVersionAdded;

    public LicenseJson(String id) {
        this.licenseId = id;
    }

    public LicenseJson() {
    }

    public void setTypedProperty(String propertyName, String valueId, String type) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException("Invalid type for Listed License SPDX Property: " + type);
    }

    public void setPrimitiveValue(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        switch (propertyName) {
            case "licenseText": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseText = (String)value;
                break;
            }
            case "licenseTextHtml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseTextHtml = (String)value;
                break;
            }
            case "name": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.name = (String)value;
                break;
            }
            case "seeAlso": 
            case "crossRef": {
                throw new InvalidSpdxPropertyException("Expected list type for " + propertyDescriptor);
            }
            case "standardLicenseHeader": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.standardLicenseHeader = (String)value;
                break;
            }
            case "standardLicenseHeaderTemplate": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.standardLicenseHeaderTemplate = (String)value;
                break;
            }
            case "standardLicenseHeaderHtml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.standardLicenseHeaderHtml = (String)value;
                break;
            }
            case "standardLicenseTemplate": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.standardLicenseTemplate = (String)value;
                break;
            }
            case "isOsiApproved": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyDescriptor);
                }
                this.isOsiApproved = (Boolean)value;
                break;
            }
            case "isFsfLibre": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyDescriptor);
                }
                this.isFsfLibre = (Boolean)value;
                break;
            }
            case "example": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.example = (String)value;
                break;
            }
            case "isDeprecatedLicenseId": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyDescriptor);
                }
                this.isDeprecatedLicenseId = (Boolean)value;
                break;
            }
            case "deprecatedVersion": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.deprecatedVersion = (String)value;
                break;
            }
            case "comment": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseComments = (String)value;
                this.comment = (String)value;
                break;
            }
            case "licenseId": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseId = (String)value;
                break;
            }
            case "obsoletedBy": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.obsoletedBy = (String)value;
                break;
            }
            case "licenseXml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseXml = (String)value;
                break;
            }
            case "listVersionAdded": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.listVersionAdded = (String)value;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
            }
        }
    }

    public void clearPropertyValueList(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        if ("seeAlso".equals(propertyName)) {
            this.seeAlso.clear();
        } else if ("crossRef".equals(propertyName)) {
            this.crossRef.clear();
        } else {
            throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
        }
    }

    public boolean addCrossRefValueToList(PropertyDescriptor propertyDescriptor, CrossRefJson value) throws InvalidSPDXAnalysisException {
        if (SpdxConstantsCompatV2.PROP_CROSS_REF.equals((Object)propertyDescriptor)) {
            return this.crossRef.add(value);
        }
        throw new InvalidSpdxPropertyException(propertyDescriptor + "is not a crossRef list type");
    }

    public boolean addPrimitiveValueToList(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        if ("seeAlso".equals(propertyName)) {
            if (!(value instanceof String)) {
                throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
            }
            return this.seeAlso.add((String)value);
        }
        if (SpdxConstantsCompatV2.PROP_CROSS_REF.getName().equals(propertyName)) {
            if (!(value instanceof CrossRefJson)) {
                throw new InvalidSpdxPropertyException("Expected CrossRefJson type for " + propertyDescriptor);
            }
            return this.crossRef.add((CrossRefJson)value);
        }
        throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
    }

    public boolean removePrimitiveValueToList(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        if ("seeAlso".equals(propertyName)) {
            return this.seeAlso.remove(value);
        }
        if ("crossRef".equals(propertyName)) {
            return this.crossRef.remove(value);
        }
        throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
    }

    public List<?> getValueList(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            return new ArrayList();
        }
        if ("seeAlso".equals(propertyName)) {
            return this.seeAlso;
        }
        if ("crossRef".equals(propertyName)) {
            return this.crossRef;
        }
        if (COLLECTION_PROPERTIES.contains(propertyDescriptor)) {
            return new ArrayList();
        }
        throw new InvalidSpdxPropertyException(propertyName + "is not a list type");
    }

    public Object getValue(PropertyDescriptor descriptor) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(descriptor);
        if (Objects.isNull(propertyName)) {
            return null;
        }
        switch (propertyName) {
            case "licenseText": {
                return this.licenseText;
            }
            case "licenseTextHtml": {
                return this.licenseTextHtml;
            }
            case "name": {
                return this.name;
            }
            case "seeAlso": {
                return this.seeAlso;
            }
            case "crossRef": {
                return this.crossRef;
            }
            case "standardLicenseHeader": {
                return this.standardLicenseHeader;
            }
            case "standardLicenseHeaderTemplate": {
                return this.standardLicenseHeaderTemplate;
            }
            case "standardLicenseHeaderHtml": {
                return this.standardLicenseHeaderHtml;
            }
            case "standardLicenseTemplate": {
                return this.standardLicenseTemplate;
            }
            case "isOsiApproved": {
                return this.isOsiApproved;
            }
            case "isFsfLibre": {
                return this.isFsfLibre;
            }
            case "example": {
                return this.example;
            }
            case "isDeprecatedLicenseId": {
                return this.isDeprecatedLicenseId;
            }
            case "deprecatedVersion": {
                return this.deprecatedVersion;
            }
            case "comment": {
                if (this.comment != null) {
                    return this.comment;
                }
                return this.licenseComments;
            }
            case "licenseId": {
                return this.licenseId;
            }
            case "licenseXml": {
                return this.licenseXml;
            }
            case "listVersionAdded": {
                return this.listVersionAdded;
            }
            case "obsoletedBy": {
                return this.obsoletedBy;
            }
        }
        return null;
    }

    public void removeProperty(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        switch (propertyName) {
            case "licenseText": {
                this.licenseText = null;
                break;
            }
            case "licenseTextHtml": {
                this.licenseTextHtml = null;
                break;
            }
            case "name": {
                this.name = null;
                break;
            }
            case "seeAlso": {
                this.seeAlso.clear();
                break;
            }
            case "crossRef": {
                this.crossRef.clear();
                break;
            }
            case "standardLicenseHeader": {
                this.standardLicenseHeader = null;
                break;
            }
            case "standardLicenseHeaderTemplate": {
                this.standardLicenseHeaderTemplate = null;
                break;
            }
            case "standardLicenseHeaderHtml": {
                this.standardLicenseHeaderHtml = null;
                break;
            }
            case "standardLicenseTemplate": {
                this.standardLicenseTemplate = null;
                break;
            }
            case "isOsiApproved": {
                this.isOsiApproved = null;
                break;
            }
            case "isFsfLibre": {
                this.isFsfLibre = null;
                break;
            }
            case "example": {
                this.example = null;
                break;
            }
            case "isDeprecatedLicenseId": {
                this.isDeprecatedLicenseId = null;
                break;
            }
            case "deprecatedVersion": {
                this.deprecatedVersion = null;
                break;
            }
            case "comment": {
                this.comment = null;
                this.licenseComments = null;
                break;
            }
            case "licenseId": {
                this.licenseId = null;
                break;
            }
            case "licenseXml": {
                this.licenseXml = null;
                break;
            }
            case "listVersionAdded": {
                this.listVersionAdded = null;
                break;
            }
            case "obsoletedBy": {
                this.obsoletedBy = null;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
            }
        }
    }

    public void copyFrom(ListedLicense fromLicense) throws InvalidSPDXAnalysisException {
        this.comment = fromLicense.getComment().orElse(null);
        this.deprecatedVersion = fromLicense.getDeprecatedVersion().orElse(null);
        this.example = null;
        this.isDeprecatedLicenseId = fromLicense.getIsDeprecatedLicenseId().orElse(false);
        this.isFsfLibre = fromLicense.getIsFsfLibre().orElse(null);
        this.licenseText = fromLicense.getLicenseText();
        this.licenseTextHtml = null;
        this.name = fromLicense.getName().orElse(null);
        this.isOsiApproved = fromLicense.getIsOsiApproved().orElse(false);
        this.seeAlso = new ArrayList<String>(fromLicense.getSeeAlsos());
        this.standardLicenseHeader = fromLicense.getStandardLicenseHeader().orElse(null);
        this.standardLicenseHeaderHtml = null;
        this.standardLicenseTemplate = fromLicense.getStandardLicenseTemplate().orElse(null);
        this.crossRef.clear();
        this.obsoletedBy = fromLicense.getObsoletedBy().orElse(null);
        this.licenseXml = fromLicense.getLicenseXml().orElse(null);
        this.listVersionAdded = fromLicense.getListVersionAdded().orElse(null);
    }

    public void copyFrom(SpdxListedLicense fromLicense) throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        this.licenseComments = null;
        this.comment = fromLicense.getComment();
        if (Objects.nonNull(this.comment) && this.comment.isEmpty()) {
            this.comment = null;
        }
        this.licenseComments = fromLicense.getComment();
        if (Objects.nonNull(this.licenseComments) && this.licenseComments.isEmpty()) {
            this.licenseComments = null;
        }
        this.deprecatedVersion = fromLicense.getDeprecatedVersion();
        if (Objects.nonNull(this.deprecatedVersion) && this.deprecatedVersion.isEmpty()) {
            this.deprecatedVersion = null;
        }
        this.example = null;
        this.isDeprecatedLicenseId = fromLicense.isDeprecated();
        this.isFsfLibre = fromLicense.getFsfLibre();
        this.licenseId = fromLicense.getId();
        this.licenseText = fromLicense.getLicenseText();
        if (Objects.nonNull(this.licenseText) && this.licenseText.isEmpty()) {
            this.licenseText = null;
        }
        this.licenseTextHtml = fromLicense.getLicenseTextHtml();
        if (Objects.nonNull(this.licenseTextHtml) && this.licenseTextHtml.isEmpty()) {
            this.licenseTextHtml = null;
        }
        this.name = fromLicense.getName();
        if (Objects.nonNull(this.name) && this.name.isEmpty()) {
            this.name = null;
        }
        this.isOsiApproved = fromLicense.isOsiApproved();
        this.seeAlso = new ArrayList<String>(fromLicense.getSeeAlso());
        this.standardLicenseHeader = fromLicense.getStandardLicenseHeader();
        if (Objects.nonNull(this.standardLicenseHeader) && this.standardLicenseHeader.isEmpty()) {
            this.standardLicenseHeader = null;
        }
        this.standardLicenseHeaderHtml = fromLicense.getLicenseHeaderHtml();
        if (Objects.nonNull(this.standardLicenseHeaderHtml) && this.standardLicenseHeaderHtml.isEmpty()) {
            this.standardLicenseHeaderHtml = null;
        }
        this.standardLicenseHeaderTemplate = fromLicense.getStandardLicenseHeaderTemplate();
        if (Objects.nonNull(this.standardLicenseHeaderTemplate) && this.standardLicenseHeaderTemplate.isEmpty()) {
            this.standardLicenseHeaderTemplate = null;
        }
        this.standardLicenseTemplate = fromLicense.getStandardLicenseTemplate();
        if (Objects.nonNull(this.standardLicenseTemplate) && this.standardLicenseTemplate.isEmpty()) {
            this.standardLicenseTemplate = null;
        }
        this.crossRef.clear();
        for (CrossRef crossRef : fromLicense.getCrossRef()) {
            this.crossRef.add(new CrossRefJson(crossRef));
        }
    }

    public boolean isPropertyValueAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        switch (propertyName) {
            case "licenseText": 
            case "licenseTextHtml": 
            case "name": 
            case "standardLicenseHeader": 
            case "standardLicenseHeaderTemplate": 
            case "standardLicenseHeaderHtml": 
            case "standardLicenseTemplate": 
            case "example": 
            case "deprecatedVersion": 
            case "comment": 
            case "licenseXml": 
            case "listVersionAdded": 
            case "obsoletedBy": 
            case "licenseId": {
                return String.class.isAssignableFrom(clazz);
            }
            case "seeAlso": 
            case "crossRef": {
                return false;
            }
            case "isOsiApproved": 
            case "isFsfLibre": 
            case "isDeprecatedLicenseId": {
                return Boolean.class.isAssignableFrom(clazz);
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
    }

    public static boolean isCollectionMembersAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        if (SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO.getName().equals(propertyName)) {
            return String.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsCompatV2.PROP_CROSS_REF.getName().equals(propertyName)) {
            return CrossRef.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTERNAL_REF.equals((Object)propertyDescriptor)) {
            return ExternalRef.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_VERIFIED_USING.equals((Object)propertyDescriptor)) {
            return IntegrityMethod.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTENSION.equals((Object)propertyDescriptor)) {
            return Extension.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER.equals((Object)propertyDescriptor)) {
            return ExternalIdentifier.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_CREATED_USING.equals((Object)propertyDescriptor)) {
            return Tool.class.isAssignableFrom(clazz);
        }
        return false;
    }

    public boolean isCollectionProperty(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        if (!PROPERTY_DESCRIPTOR_TO_VALUE_NAME.containsKey(propertyDescriptor)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor.getName());
        }
        return COLLECTION_PROPERTIES.contains(propertyDescriptor);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors() {
        ArrayList<PropertyDescriptor> retval = new ArrayList<PropertyDescriptor>();
        ALL_PROPERTY_DESCRIPTORS.forEach(propDescriptor -> {
            try {
                if (Objects.nonNull(this.getValue((PropertyDescriptor)propDescriptor))) {
                    retval.add((PropertyDescriptor)propDescriptor);
                }
            }
            catch (InvalidSpdxPropertyException invalidSpdxPropertyException) {
                // empty catch block
            }
        });
        return retval;
    }

    static {
        HashMap<PropertyDescriptor, String> descriptorsToValue = new HashMap<PropertyDescriptor, String>();
        HashSet<PropertyDescriptor> collectionProperties = new HashSet<PropertyDescriptor>();
        descriptorsToValue.put(SpdxConstantsV3.PROP_LICENSE_TEXT, "licenseText");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LICENSE_TEXT, "licenseText");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LICENSE_TEXT_HTML, "licenseTextHtml");
        descriptorsToValue.put(SpdxConstantsV3.PROP_NAME, "name");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LICENSE_NAME, "name");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_NAME, "name");
        descriptorsToValue.put(SpdxConstantsV3.PROP_STANDARD_LICENSE_HEADER, "standardLicenseHeader");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_STD_LICENSE_NOTICE, "standardLicenseHeader");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_STD_LICENSE_HEADER_TEMPLATE, "standardLicenseHeaderTemplate");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LICENSE_HEADER_HTML, "standardLicenseHeaderHtml");
        descriptorsToValue.put(SpdxConstantsV3.PROP_STANDARD_LICENSE_TEMPLATE, "standardLicenseTemplate");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_STD_LICENSE_TEMPLATE, "standardLicenseTemplate");
        descriptorsToValue.put(SpdxConstantsV3.PROP_IS_OSI_APPROVED, "isOsiApproved");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_STD_LICENSE_OSI_APPROVED, "isOsiApproved");
        descriptorsToValue.put(SpdxConstantsV3.PROP_IS_FSF_LIBRE, "isFsfLibre");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_STD_LICENSE_FSF_LIBRE, "isFsfLibre");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_EXAMPLE, "example");
        descriptorsToValue.put(SpdxConstantsV3.PROP_IS_DEPRECATED_LICENSE_ID, "isDeprecatedLicenseId");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED, "isDeprecatedLicenseId");
        descriptorsToValue.put(SpdxConstantsV3.PROP_DEPRECATED_VERSION, "deprecatedVersion");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LIC_DEPRECATED_VERSION, "deprecatedVersion");
        descriptorsToValue.put(SpdxConstantsV3.PROP_COMMENT, "comment");
        descriptorsToValue.put(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, "comment");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LICENSE_ID, "licenseId");
        descriptorsToValue.put(SpdxConstantsV3.PROP_SEE_ALSO, "seeAlso");
        collectionProperties.add(SpdxConstantsV3.PROP_SEE_ALSO);
        descriptorsToValue.put(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO, "seeAlso");
        collectionProperties.add(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO);
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_CROSS_REF, "crossRef");
        collectionProperties.add(SpdxConstantsCompatV2.PROP_CROSS_REF);
        descriptorsToValue.put(SpdxConstantsV3.PROP_LICENSE_XML, "licenseXml");
        descriptorsToValue.put(SpdxConstantsV3.PROP_OBSOLETED_BY, "obsoletedBy");
        descriptorsToValue.put(SpdxConstantsV3.PROP_LIST_VERSION_ADDED, "listVersionAdded");
        descriptorsToValue.put(SpdxConstantsV3.PROP_CREATION_INFO, "creationInfo");
        descriptorsToValue.put(SpdxConstantsV3.PROP_EXTERNAL_REF, "externalRef");
        collectionProperties.add(SpdxConstantsV3.PROP_EXTERNAL_REF);
        descriptorsToValue.put(SpdxConstantsV3.PROP_VERIFIED_USING, "verifiedUsing");
        collectionProperties.add(SpdxConstantsV3.PROP_VERIFIED_USING);
        descriptorsToValue.put(SpdxConstantsV3.PROP_EXTENSION, "extension");
        collectionProperties.add(SpdxConstantsV3.PROP_EXTENSION);
        descriptorsToValue.put(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER, "externalIdentifier");
        collectionProperties.add(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER);
        descriptorsToValue.put(SpdxConstantsV3.PROP_CREATED_USING, "createdUsing");
        collectionProperties.add(SpdxConstantsV3.PROP_CREATED_USING);
        descriptorsToValue.put(SpdxConstantsV3.PROP_DESCRIPTION, "description");
        descriptorsToValue.put(SpdxConstantsV3.PROP_SUMMARY, "summary");
        PROPERTY_DESCRIPTOR_TO_VALUE_NAME = Collections.unmodifiableMap(descriptorsToValue);
        ALL_PROPERTY_DESCRIPTORS = Collections.unmodifiableList(new ArrayList(descriptorsToValue.keySet()));
        COLLECTION_PROPERTIES = Collections.unmodifiableSet(collectionProperties);
    }
}

