/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.InvalidSpdxPropertyException;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.storage.PropertyDescriptor;

public class CrossRefJson {
    public String match;
    public String url;
    public Boolean isValid;
    public Boolean isLive;
    public String timestamp;
    public Boolean isWayBackLink;
    public Integer order;
    private transient String id;

    public CrossRefJson() {
    }

    public CrossRefJson(CrossRef crossRef) throws InvalidSPDXAnalysisException {
        this.id = crossRef.getId();
        crossRef.getMatch().ifPresent(s -> {
            this.match = s;
        });
        crossRef.getUrl().ifPresent(s -> {
            this.url = s;
        });
        crossRef.getValid().ifPresent(aBoolean -> {
            this.isValid = aBoolean;
        });
        crossRef.getLive().ifPresent(aBoolean -> {
            this.isLive = aBoolean;
        });
        crossRef.getIsWayBackLink().ifPresent(aBoolean -> {
            this.isWayBackLink = aBoolean;
        });
        crossRef.getTimestamp().ifPresent(s -> {
            this.timestamp = s;
        });
        crossRef.getOrder().ifPresent(integer -> {
            this.order = integer;
        });
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors() {
        ArrayList<PropertyDescriptor> retval = new ArrayList<PropertyDescriptor>();
        if (Objects.nonNull(this.match)) {
            retval.add(new PropertyDescriptor("match", "http://spdx.org/rdf/terms#"));
        }
        if (Objects.nonNull(this.url)) {
            retval.add(new PropertyDescriptor("url", "http://spdx.org/rdf/terms#"));
        }
        if (Objects.nonNull(this.isValid)) {
            retval.add(new PropertyDescriptor("isValid", "http://spdx.org/rdf/terms#"));
        }
        if (Objects.nonNull(this.isLive)) {
            retval.add(new PropertyDescriptor("isLive", "http://spdx.org/rdf/terms#"));
        }
        if (Objects.nonNull(this.timestamp)) {
            retval.add(new PropertyDescriptor("timestamp", "http://spdx.org/rdf/terms#"));
        }
        if (Objects.nonNull(this.isWayBackLink)) {
            retval.add(new PropertyDescriptor("isWayBackLink", "http://spdx.org/rdf/terms#"));
        }
        if (Objects.nonNull(this.order)) {
            retval.add(new PropertyDescriptor("order", "http://spdx.org/rdf/terms#"));
        }
        return retval;
    }

    public void setPrimitiveValue(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        switch (propertyDescriptor.getName()) {
            case "match": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.match = (String)value;
                break;
            }
            case "url": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.url = (String)value;
                break;
            }
            case "timestamp": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.timestamp = (String)value;
                break;
            }
            case "isValid": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected boolean type for " + propertyDescriptor);
                }
                this.isValid = (Boolean)value;
                break;
            }
            case "isLive": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected boolean type for " + propertyDescriptor);
                }
                this.isLive = (Boolean)value;
                break;
            }
            case "isWayBackLink": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected boolean type for " + propertyDescriptor);
                }
                this.isWayBackLink = (Boolean)value;
                break;
            }
            case "order": {
                if (!(value instanceof Integer)) {
                    throw new InvalidSpdxPropertyException("Expected integer type for " + propertyDescriptor);
                }
                this.order = (Integer)value;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyDescriptor);
            }
        }
    }

    public void clearPropertyValueList(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(propertyDescriptor + " is not a list type.");
    }

    public boolean addPrimitiveValueToList(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(propertyDescriptor + " is not a list type.");
    }

    public boolean removePrimitiveValueToList(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(propertyDescriptor + " is not a list type.");
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String crossRefId) {
        this.id = crossRefId;
    }

    public List<?> getValueList(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(propertyDescriptor + " is not a list type.");
    }

    @Nullable
    public Object getValue(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        switch (propertyDescriptor.getName()) {
            case "match": {
                return this.match;
            }
            case "url": {
                return this.url;
            }
            case "isValid": {
                return this.isValid;
            }
            case "isLive": {
                return this.isLive;
            }
            case "timestamp": {
                return this.timestamp;
            }
            case "isWayBackLink": {
                return this.isWayBackLink;
            }
            case "order": {
                return this.order;
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyDescriptor);
    }

    public void removeProperty(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        switch (propertyDescriptor.getName()) {
            case "match": {
                this.match = null;
                break;
            }
            case "url": {
                this.url = null;
                break;
            }
            case "isValid": {
                this.isValid = null;
                break;
            }
            case "isLive": {
                this.isLive = null;
                break;
            }
            case "timestamp": {
                this.timestamp = null;
                break;
            }
            case "isWayBackLink": {
                this.isWayBackLink = null;
                break;
            }
            case "order": {
                this.order = null;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyDescriptor);
            }
        }
    }

    public boolean isCollectionMembersAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        return false;
    }

    public boolean isPropertyValueAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSpdxPropertyException {
        switch (propertyDescriptor.getName()) {
            case "match": 
            case "url": 
            case "timestamp": {
                return String.class.isAssignableFrom(clazz);
            }
            case "isValid": 
            case "isLive": 
            case "isWayBackLink": {
                return Boolean.class.isAssignableFrom(clazz);
            }
            case "order": {
                return Integer.class.isAssignableFrom(clazz);
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyDescriptor);
    }

    public boolean isCollectionProperty(String propertyName) {
        return false;
    }
}

