/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;

public class SpdxListedLicenseWebStore
extends SpdxListedLicenseModelStore {
    private static final int READ_TIMEOUT = 5000;

    private InputStream getUrlInputStream(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(5000);
        int status = connection.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            String redirectUrl = connection.getHeaderField("Location");
            if (Objects.isNull(redirectUrl) || redirectUrl.isEmpty()) {
                throw new IOException("Invalid redirect URL response");
            }
            connection = (HttpURLConnection)new URL(redirectUrl).openConnection();
        }
        return connection.getInputStream();
    }

    @Override
    InputStream getTocInputStream() throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/licenses.json"));
    }

    @Override
    InputStream getLicenseInputStream(String licenseId) throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/" + licenseId + ".json"));
    }

    @Override
    InputStream getExceptionTocInputStream() throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/exceptions.json"));
    }

    @Override
    InputStream getExceptionInputStream(String exceptionId) throws IOException {
        return this.getLicenseInputStream(exceptionId);
    }

    @Override
    public void close() throws Exception {
    }
}

