/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.LicenseException;
import org.spdx.storage.IModelStore;

public class WithExceptionOperator
extends AnyLicenseInfo {
    public WithExceptionOperator() throws InvalidSPDXAnalysisException {
    }

    public WithExceptionOperator(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public WithExceptionOperator(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public WithExceptionOperator(AnyLicenseInfo license, LicenseException exception) throws InvalidSPDXAnalysisException {
        this.setLicense(license);
        this.setException(exception);
    }

    @Override
    public String getType() {
        return "WithExceptionOperator";
    }

    public AnyLicenseInfo getLicense() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue("member");
        if (!retval.isPresent()) {
            throw new InvalidSPDXAnalysisException("Required license for exception is missing");
        }
        return retval.get();
    }

    public void setLicense(AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("member", license);
    }

    public LicenseException getException() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("licenseException");
        if (!retval.isPresent()) {
            throw new InvalidSPDXAnalysisException("Required exception is missing for with exception operator");
        }
        if (!(retval.get() instanceof LicenseException)) {
            throw new SpdxInvalidTypeException("Exception is not of type LicenseException");
        }
        return (LicenseException)retval.get();
    }

    public void setException(LicenseException exception) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseException", exception);
    }

    @Override
    public String toString() {
        try {
            Optional<Object> license = this.getObjectPropertyValue("member");
            Optional<Object> exception = this.getObjectPropertyValue("licenseException");
            if (!license.isPresent() || !exception.isPresent()) {
                return "UNDEFINED WITH EXCEPTION";
            }
            return license.get().toString() + " WITH " + exception.get().toString();
        }
        catch (Exception ex) {
            return "UNDEFINED WITH EXCEPTION";
        }
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional<Object> license = this.getObjectPropertyValue("member");
            if (license.isPresent()) {
                if (license.get() instanceof AnyLicenseInfo) {
                    retval.addAll(((AnyLicenseInfo)license.get()).verify(verifiedIds));
                } else {
                    retval.add("Invalid type for With Operator license");
                }
            } else {
                retval.add("Missing required license for With Operator");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting license property of a With operator: " + e.getMessage());
        }
        try {
            Optional<Object> exception = this.getObjectPropertyValue("licenseException");
            if (exception.isPresent()) {
                if (exception.get() instanceof LicenseException) {
                    retval.addAll(((LicenseException)exception.get()).verify(verifiedIds));
                } else {
                    retval.add("Invalid type for With Operator exception");
                }
            } else {
                retval.add("Missing required exception for With Operator");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting exception property of a With operator: " + e.getMessage());
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WithExceptionOperator)) {
            return false;
        }
        WithExceptionOperator comp = (WithExceptionOperator)o;
        AnyLicenseInfo myLicense = null;
        AnyLicenseInfo compLicense = null;
        LicenseException myException = null;
        LicenseException compException = null;
        try {
            myLicense = this.getLicense();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            compLicense = comp.getLicense();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            myException = this.getException();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            compException = comp.getException();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        if (!Objects.equals(myLicense, compLicense)) {
            return false;
        }
        return Objects.equals(myException, compException);
    }

    @Override
    public int hashCode() {
        int licHashCode = 0;
        int exceptionHashCode = 0;
        try {
            licHashCode = this.getLicense().hashCode();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            exceptionHashCode = this.getException().hashCode();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        return 0x3D1 ^ licHashCode ^ exceptionHashCode;
    }
}

