/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.license.ListedLicenseException;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.storage.listedlicense.IListedLicenseStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseLocalStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseWebStore;

public class ListedLicenses {
    static final Logger logger = LoggerFactory.getLogger((String)ListedLicenses.class.getName());
    private static final String PROPERTIES_DIR = "resources";
    private static final String LISTED_LICENSE_PROPERTIES_FILENAME = "resources/licenses.properties";
    Properties licenseProperties = ListedLicenses.loadLicenseProperties();
    boolean onlyUseLocalLicenses = Boolean.parseBoolean(System.getProperty("SPDXParser.OnlyUseLocalLicenses", this.licenseProperties.getProperty("OnlyUseLocalLicenses", "false")));
    private IListedLicenseStore licenseModelStore;
    private static ListedLicenses listedLicenses = null;
    private static final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();

    private ListedLicenses() {
        this.initializeLicenseModelStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLicenseProperties() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            Properties licenseProperties = new Properties();
            InputStream in = null;
            try {
                in = ListedLicenses.class.getResourceAsStream("/resources/licenses.properties");
                if (in != null) {
                    licenseProperties.load(in);
                }
            }
            catch (IOException e) {
                logger.warn("IO Exception reading listed license properties file: " + e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close listed license properties file: " + e.getMessage());
                    }
                }
            }
            Properties properties = licenseProperties;
            return properties;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    private void initializeLicenseModelStore() {
        block8: {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (!this.onlyUseLocalLicenses) {
                    try {
                        this.licenseModelStore = new SpdxListedLicenseWebStore();
                    }
                    catch (InvalidSPDXAnalysisException ex) {
                        logger.warn("Unable to open SPDX listed license model store - using locally cached licenses", (Throwable)ex);
                        this.licenseModelStore = null;
                    }
                }
                if (this.licenseModelStore != null) break block8;
                try {
                    this.licenseModelStore = new SpdxListedLicenseLocalStore();
                }
                catch (InvalidSPDXAnalysisException ex) {
                    logger.error("Error loading cached SPDX licenses");
                    throw new RuntimeException("Unexpected error loading SPDX Listed Licenses");
                }
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
    }

    public static ListedLicenses getListedLicenses() {
        ListedLicenses retval = null;
        listedLicenseModificationLock.readLock().lock();
        try {
            retval = listedLicenses;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        if (Objects.isNull(retval)) {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (listedLicenses == null) {
                    listedLicenses = new ListedLicenses();
                }
                retval = listedLicenses;
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
        return retval;
    }

    public static ListedLicenses resetListedLicenses() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            ListedLicenses listedLicenses = ListedLicenses.listedLicenses = new ListedLicenses();
            return listedLicenses;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public boolean isSpdxListedLicenseId(String licenseId) {
        return this.licenseModelStore.isSpdxListedLicenseId("https://spdx.org/licenses/", licenseId);
    }

    public boolean isSpdxListedExceptionId(String exceptionId) {
        return this.licenseModelStore.isSpdxListedExceptionId("https://spdx.org/licenses/", exceptionId);
    }

    public SpdxListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return (SpdxListedLicense)SpdxModelFactory.createModelObject(this.licenseModelStore, "https://spdx.org/licenses/", licenseId, "ListedLicense", null);
    }

    public ListedLicenseException getListedExceptionById(String exceptionId) throws InvalidSPDXAnalysisException {
        return (ListedLicenseException)SpdxModelFactory.createModelObject(this.licenseModelStore, "https://spdx.org/licenses/", exceptionId, "ListedLicenseException", null);
    }

    public List<String> getSpdxListedLicenseIds() {
        listedLicenseModificationLock.readLock().lock();
        try {
            List<String> list = this.licenseModelStore.getSpdxListedLicenseIds();
            return list;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    public String getLicenseListVersion() {
        return this.licenseModelStore.getLicenseListVersion();
    }

    public List<String> getSpdxListedExceptionIds() {
        return this.licenseModelStore.getSpdxListedExceptionIds();
    }

    public Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        return this.licenseModelStore.listedLicenseIdCaseSensitive(licenseId);
    }

    public Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        return this.licenseModelStore.listedExceptionIdCaseSensitive(exceptionId);
    }
}

