/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelObject;
import org.spdx.storage.IModelStore;

public class LicenseException
extends ModelObject {
    public LicenseException(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        if (!(this instanceof IndividualUriValue)) {
            this.setPropertyValue("licenseExceptionId", id);
        }
    }

    public LicenseException(String id, String name, String text, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        this(id, name, text);
        this.setSeeAlso(seeAlso);
        this.setComment(comment);
    }

    public LicenseException(String id, String name, String text, String template, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        this(id, name, text, seeAlso, comment);
        this.setLicenseExceptionTemplate(template);
    }

    public LicenseException(String id, String name, String text) throws InvalidSPDXAnalysisException {
        super(id);
        this.setName(name);
        this.setLicenseExceptionText(text);
        if (!(this instanceof IndividualUriValue)) {
            this.setPropertyValue("licenseExceptionId", id);
        }
    }

    public String getComment() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("comment");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("comment", comment);
    }

    @Deprecated
    public String getExample() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("example");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    @Deprecated
    public void setExample(String example) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("example", example);
    }

    public String getLicenseExceptionId() {
        return this.getId();
    }

    public String getLicenseExceptionTemplate() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("licenseExceptionTemplate");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setLicenseExceptionTemplate(String template) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseExceptionTemplate", template);
    }

    public String getLicenseExceptionText() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("licenseExceptionText");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setLicenseExceptionText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseExceptionText", text);
    }

    public String getName() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("name");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setName(String name) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("name", name);
    }

    public Collection<String> getSeeAlso() throws InvalidSPDXAnalysisException {
        return this.getStringCollection("seeAlso");
    }

    public void setSeeAlso(Collection<String> seeAlso) throws InvalidSPDXAnalysisException {
        if (seeAlso == null) {
            this.clearValueCollection("seeAlso");
        } else {
            this.setPropertyValue("seeAlso", seeAlso);
        }
    }

    public boolean isDeprecated() throws InvalidSPDXAnalysisException {
        Optional<Boolean> deprecated = this.getBooleanPropertyValue("isDeprecatedLicenseId");
        return deprecated.isPresent() && deprecated.get() != false;
    }

    public void setDeprecated(Boolean deprecated) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("isDeprecatedLicenseId", deprecated);
    }

    public String getDeprecatedVersion() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("deprecatedVersion");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setDeprecatedVersion(String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("deprecatedVersion", deprecatedVersion);
    }

    @Override
    public String getType() {
        return "LicenseException";
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseExceptionId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required exception ID");
        }
        try {
            String name = this.getName();
            if (name == null || name.isEmpty()) {
                retval.add("Missing required exception name");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for name");
        }
        try {
            this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for comment");
        }
        try {
            this.getSeeAlso();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for seeAlso");
        }
        try {
            this.getLicenseExceptionTemplate();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for exception template");
        }
        try {
            String exceptionText = this.getLicenseExceptionText();
            if (exceptionText == null || exceptionText.trim().isEmpty()) {
                retval.add("Missing required exception text for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for exception text");
        }
        return retval;
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

