/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.storage.IModelStore;
import org.spdx.utility.compare.LicenseCompareHelper;

public abstract class License
extends SimpleLicensingInfo {
    static final String XML_LITERAL = "^^http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private boolean templateInHtml = false;

    public License(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    License(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public String getLicenseText() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("licenseText");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setLicenseText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseText", text);
    }

    public String getStandardLicenseHeader() throws InvalidSPDXAnalysisException {
        Optional<String> standardLicenseHeader = this.getStringPropertyValue("standardLicenseHeader");
        if (standardLicenseHeader.isPresent()) {
            return StringEscapeUtils.unescapeHtml4((String)standardLicenseHeader.get());
        }
        return "";
    }

    public String getStandardLicenseHeaderTemplate() throws InvalidSPDXAnalysisException {
        Optional<String> standardLicenseHeaderTemplate = this.getStringPropertyValue("standardLicenseHeaderTemplate");
        if (standardLicenseHeaderTemplate.isPresent()) {
            return StringEscapeUtils.unescapeHtml4((String)standardLicenseHeaderTemplate.get());
        }
        return "";
    }

    public void setStandardLicenseHeaderTemplate(String standardLicenseHeaderTemplate) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("standardLicenseHeaderTemplate", standardLicenseHeaderTemplate);
    }

    public void setStandardLicenseHeader(String standardLicenseHeader) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("standardLicenseHeader", standardLicenseHeader);
    }

    public String getStandardLicenseTemplate() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("standardLicenseTemplate");
        if (!o.isPresent()) {
            return "";
        }
        String standardLicenseTemplate = o.get();
        if (standardLicenseTemplate != null && standardLicenseTemplate.endsWith(XML_LITERAL)) {
            standardLicenseTemplate = standardLicenseTemplate.substring(0, standardLicenseTemplate.length() - XML_LITERAL.length());
        }
        if (standardLicenseTemplate != null && this.templateInHtml) {
            standardLicenseTemplate = SpdxLicenseTemplateHelper.htmlToText(standardLicenseTemplate);
        }
        return standardLicenseTemplate;
    }

    public void setStandardLicenseTemplate(String template) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("standardLicenseTemplate", template);
    }

    @Override
    public String toString() {
        if (this.getId() == null) {
            return "NULL LICENSE";
        }
        return this.getId();
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        }
        try {
            String name = this.getName();
            if (name == null || name.isEmpty()) {
                retval.add("Missing required license name");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for name");
        }
        try {
            this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for comment");
        }
        try {
            this.getSeeAlso();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for seeAlso");
        }
        try {
            this.getStandardLicenseHeader();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for standard license header");
        }
        try {
            this.getStandardLicenseTemplate();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for standard license template");
        }
        try {
            this.getStandardLicenseHeaderTemplate();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for standard license header template");
        }
        try {
            String licenseText = this.getLicenseText();
            if (licenseText == null || licenseText.isEmpty()) {
                retval.add("Missing required license text for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for license text");
        }
        return retval;
    }

    public boolean isFsfLibre() throws InvalidSPDXAnalysisException {
        Optional<Boolean> libre = this.getBooleanPropertyValue("isFsfLibre");
        if (!libre.isPresent()) {
            return false;
        }
        return libre.get();
    }

    public boolean isNotFsfLibre() throws InvalidSPDXAnalysisException {
        Optional<Boolean> fsfLibre = this.getBooleanPropertyValue("isFsfLibre");
        return fsfLibre.isPresent() && fsfLibre.get() == false;
    }

    public Boolean getFsfLibre() throws InvalidSPDXAnalysisException {
        Optional<Boolean> libre = this.getBooleanPropertyValue("isFsfLibre");
        if (libre.isPresent()) {
            return libre.get();
        }
        return null;
    }

    public boolean isOsiApproved() throws InvalidSPDXAnalysisException {
        Optional<Boolean> osiApproved = this.getBooleanPropertyValue("isOsiApproved");
        return osiApproved.isPresent() && osiApproved.get() != false;
    }

    public boolean isDeprecated() throws InvalidSPDXAnalysisException {
        Optional<Boolean> deprecated = this.getBooleanPropertyValue("isDeprecatedLicenseId");
        return deprecated.isPresent() && deprecated.get() != false;
    }

    public void setOsiApproved(Boolean osiApproved) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("isOsiApproved", osiApproved);
    }

    public void setFsfLibre(Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("isFsfLibre", fsfLibre);
    }

    public void setDeprecated(Boolean deprecated) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("isDeprecatedLicenseId", deprecated);
    }

    public IModelStore.ModelUpdate updateSetDeprecated(Boolean deprecated) throws InvalidSPDXAnalysisException {
        return this.updatePropertyValue("isDeprecatedLicenseId", deprecated);
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreExternalReferences) throws InvalidSPDXAnalysisException {
        if (compare instanceof License) {
            return LicenseCompareHelper.isLicenseTextEquivalent(this.getLicenseText(), ((License)compare).getLicenseText());
        }
        return super.equivalent(compare, ignoreExternalReferences);
    }
}

