/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.storage.IModelStore;
import org.spdx.utility.compare.LicenseCompareHelper;

public class ExtractedLicenseInfo
extends SimpleLicensingInfo
implements Comparable<ExtractedLicenseInfo> {
    public ExtractedLicenseInfo() throws InvalidSPDXAnalysisException {
        super(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.LicenseRef, DefaultModelStore.getDefaultDocumentUri()));
    }

    public ExtractedLicenseInfo(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public ExtractedLicenseInfo(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public ExtractedLicenseInfo(String id, String text) throws InvalidSPDXAnalysisException {
        super(id);
        this.setExtractedText(text);
    }

    @Override
    public String getType() {
        return "ExtractedLicensingInfo";
    }

    @Override
    public String toString() {
        return this.getLicenseId();
    }

    public String getExtractedText() throws InvalidSPDXAnalysisException {
        Optional<String> o = this.getStringPropertyValue("extractedText");
        if (o.isPresent()) {
            return o.get();
        }
        return "";
    }

    public void setExtractedText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("extractedText", text);
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        } else {
            String idError = SpdxVerificationHelper.verifyNonStdLicenseid(id);
            if (idError != null && !idError.isEmpty()) {
                retval.add(idError);
            }
        }
        try {
            String licenseText = this.getExtractedText();
            if (licenseText == null || licenseText.isEmpty()) {
                retval.add("Missing required license text for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            retval.add("Unable to fetch license text: " + ex.getMessage());
        }
        return retval;
    }

    @Override
    public int compareTo(ExtractedLicenseInfo o) {
        try {
            if (this.getLicenseId() == null) {
                if (o.getLicenseId() == null) {
                    if (this.getExtractedText() == null) {
                        if (o.getExtractedText() == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (o.getExtractedText() == null) {
                        return -1;
                    }
                    return this.getExtractedText().compareToIgnoreCase(o.getExtractedText());
                }
                return 1;
            }
            if (o.getLicenseId() == null) {
                return -1;
            }
            return this.getLicenseId().compareToIgnoreCase(o.getLicenseId());
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean equivalent(ModelObject compare) throws InvalidSPDXAnalysisException {
        if (compare instanceof ExtractedLicenseInfo) {
            return LicenseCompareHelper.isLicenseTextEquivalent(this.getExtractedText(), ((ExtractedLicenseInfo)compare).getExtractedText());
        }
        return false;
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare);
    }
}

