/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.ModelCollection;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.pointer.ByteOffsetPointer;
import org.spdx.library.model.pointer.LineCharPointer;
import org.spdx.library.model.pointer.SinglePointer;
import org.spdx.library.model.pointer.StartEndPointer;
import org.spdx.storage.IModelStore;

public class SpdxSnippet
extends SpdxItem
implements Comparable<SpdxSnippet> {
    private Collection<StartEndPointer> allRanges;

    public SpdxSnippet() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous, DefaultModelStore.getDefaultDocumentUri()));
    }

    public SpdxSnippet(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public SpdxSnippet(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        this.allRanges = new ModelCollection(modelStore, documentUri, id, "range", copyManager, StartEndPointer.class);
    }

    public SpdxSnippet(SpdxSnippetBuilder spdxSnippetBuilder) throws InvalidSPDXAnalysisException {
        this(spdxSnippetBuilder.modelStore, spdxSnippetBuilder.documentUri, spdxSnippetBuilder.id, spdxSnippetBuilder.copyManager, true);
        this.setCopyrightText(spdxSnippetBuilder.copyrightText);
        this.setName(spdxSnippetBuilder.name);
        this.setLicenseConcluded(spdxSnippetBuilder.concludedLicense);
        this.getLicenseInfoFromFiles().addAll(spdxSnippetBuilder.licenseInfosFromFile);
        this.setSnippetFromFile(spdxSnippetBuilder.snippetFromFile);
        this.setByteRange(spdxSnippetBuilder.startByte, spdxSnippetBuilder.endByte);
        this.getAnnotations().addAll(spdxSnippetBuilder.annotations);
        this.getRelationships().addAll(spdxSnippetBuilder.relationships);
        this.setComment(spdxSnippetBuilder.comment);
        this.setLicenseComments(spdxSnippetBuilder.licenseComments);
        if (spdxSnippetBuilder.startLine > 0) {
            this.setLineRange(spdxSnippetBuilder.startLine, spdxSnippetBuilder.endLine);
        }
    }

    @Override
    public String getType() {
        return "Snippet";
    }

    @Override
    public String getLicenseInfoFromFilesPropertyName() {
        return "licenseInfoInSnippet";
    }

    @Nullable
    public SpdxFile getSnippetFromFile() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("snippetFromFile");
        if (!retval.isPresent()) {
            return null;
        }
        if (!(retval.get() instanceof SpdxFile)) {
            throw new SpdxInvalidTypeException("Invalid type returned for getSnippetFromFile.  Expected SpdxFile, returned type " + retval.get().getClass().toString());
        }
        return (SpdxFile)retval.get();
    }

    public SpdxSnippet setSnippetFromFile(SpdxFile snippetFromFile) throws InvalidSPDXAnalysisException {
        Optional<StartEndPointer> lineRange;
        if (this.strict && Objects.isNull(snippetFromFile)) {
            throw new InvalidSPDXAnalysisException("Can not set required snippetFromFile to null");
        }
        this.setPropertyValue("snippetFromFile", snippetFromFile);
        StartEndPointer byteRange = this.getByteRange();
        if (byteRange != null) {
            if (!this.strict) {
                byteRange.setStrict(this.strict);
            }
            if (byteRange.getStartPointer() != null) {
                byteRange.getStartPointer().setReference(snippetFromFile);
            }
            if (byteRange.getEndPointer() != null) {
                byteRange.getEndPointer().setReference(snippetFromFile);
            }
        }
        if ((lineRange = this.getLineRange()).isPresent()) {
            if (!this.strict) {
                lineRange.get().setStrict(this.strict);
            }
            if (lineRange.get().getStartPointer() != null) {
                lineRange.get().getStartPointer().setReference(snippetFromFile);
            }
            if (lineRange.get().getEndPointer() != null) {
                lineRange.get().getEndPointer().setReference(snippetFromFile);
            }
        }
        return this;
    }

    public StartEndPointer getByteRange() throws InvalidSPDXAnalysisException {
        for (StartEndPointer range : this.allRanges) {
            if (!(range.getStartPointer() instanceof ByteOffsetPointer)) continue;
            if (!(range.getEndPointer() instanceof ByteOffsetPointer)) {
                logger.error("Incompatable start and end pointer types - must both be offset or line types");
                throw new InvalidSPDXAnalysisException("Incompatable start and end snippet specification - mixing byte and line ranges");
            }
            return range;
        }
        return null;
    }

    public SpdxSnippet setByteRange(int startByte, int endByte) throws InvalidSPDXAnalysisException {
        SpdxFile snippetFromFile = this.getSnippetFromFile();
        if (this.strict) {
            if (endByte <= startByte) {
                throw new InvalidSPDXAnalysisException("Ending byte of a range must be greater than the starting byte");
            }
            if (Objects.isNull(snippetFromFile)) {
                throw new InvalidSPDXAnalysisException("Snippets from file must be set prior to setting byte range");
            }
        }
        ByteOffsetPointer startPointer = this.createByteOffsetPointer(snippetFromFile, startByte);
        ByteOffsetPointer endPointer = this.createByteOffsetPointer(snippetFromFile, endByte);
        StartEndPointer byteRange = this.createStartEndPointer(startPointer, endPointer);
        ArrayList<StartEndPointer> existing = new ArrayList<StartEndPointer>();
        for (StartEndPointer range : this.allRanges) {
            if (!(range.getStartPointer() instanceof ByteOffsetPointer)) continue;
            existing.add(range);
        }
        this.allRanges.removeAll(existing);
        this.allRanges.add(byteRange);
        return this;
    }

    public Optional<StartEndPointer> getLineRange() throws InvalidSPDXAnalysisException {
        for (StartEndPointer range : this.allRanges) {
            if (!(range.getStartPointer() instanceof LineCharPointer)) continue;
            if (!(range.getEndPointer() instanceof LineCharPointer)) {
                logger.error("Incompatable start and end pointer types - must both be offset or line types");
                throw new InvalidSPDXAnalysisException("Incompatable start and end snippet specification - mixing byte and line ranges");
            }
            return Optional.of(range);
        }
        return Optional.empty();
    }

    public SpdxSnippet setLineRange(int startLine, int endLine) throws InvalidSPDXAnalysisException {
        SpdxFile snippetFromFile = this.getSnippetFromFile();
        if (this.strict) {
            if (endLine <= startLine) {
                throw new InvalidSPDXAnalysisException("Ending line of a range must be greater than the starting line");
            }
            if (Objects.isNull(snippetFromFile)) {
                throw new InvalidSPDXAnalysisException("Snippets from file must be set prior to setting line range");
            }
        }
        LineCharPointer startPointer = this.createLineCharPointer(snippetFromFile, startLine);
        LineCharPointer endPointer = this.createLineCharPointer(snippetFromFile, endLine);
        StartEndPointer lineRange = this.createStartEndPointer(startPointer, endPointer);
        ArrayList<StartEndPointer> existing = new ArrayList<StartEndPointer>();
        for (StartEndPointer range : this.allRanges) {
            if (!(range.getStartPointer() instanceof LineCharPointer)) continue;
            existing.add(range);
        }
        this.allRanges.removeAll(existing);
        if (Objects.nonNull(lineRange)) {
            this.setPointerReferences(lineRange);
            this.allRanges.add(lineRange);
        }
        return this;
    }

    private void setPointerReferences(@Nullable StartEndPointer pointer) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(pointer)) {
            return;
        }
        SpdxFile fromFile = this.getSnippetFromFile();
        if (Objects.nonNull(fromFile)) {
            SinglePointer endPointer;
            SinglePointer startPointer = pointer.getStartPointer();
            if (Objects.nonNull(startPointer)) {
                startPointer.setReference(fromFile);
            }
            if (Objects.nonNull(endPointer = pointer.getEndPointer())) {
                endPointer.setReference(fromFile);
            }
        }
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds) {
        List<String> retval = super._verify(verifiedIds);
        String snippetName = "[Unnamed Snippet]";
        try {
            Optional<String> name = this.getName();
            if (name.isPresent()) {
                snippetName = name.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting name: " + e.getMessage());
        }
        try {
            SpdxFile snippetFromFile = this.getSnippetFromFile();
            if (snippetFromFile == null) {
                retval.add("Missing snippet from file in Snippet " + snippetName);
            } else {
                retval.addAll(snippetFromFile.verify(verifiedIds));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting snippetFromFile: " + e.getMessage());
        }
        try {
            StartEndPointer byteRange = this.getByteRange();
            if (byteRange == null) {
                retval.add("Missing snippet byte range from Snippet " + snippetName);
            } else {
                retval.addAll(byteRange.verify(verifiedIds));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting byteRange: " + e.getMessage());
        }
        try {
            Optional<StartEndPointer> lineRange = this.getLineRange();
            if (lineRange.isPresent()) {
                retval.addAll(lineRange.get().verify(verifiedIds));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting lineRange: " + e.getMessage());
        }
        return retval;
    }

    @Override
    public int compareTo(SpdxSnippet o) {
        try {
            if (o == null) {
                return 1;
            }
            int retval = 0;
            Optional<String> name = this.getName();
            Optional<String> compName = o.getName();
            if (name.isPresent()) {
                if (compName.isPresent()) {
                    retval = name.get().compareTo(compName.get());
                } else {
                    return 1;
                }
            }
            SpdxFile snippetFromFile = this.getSnippetFromFile();
            SpdxFile compSnippetFromFile = o.getSnippetFromFile();
            if (retval == 0 && snippetFromFile != null) {
                retval = snippetFromFile.compareTo(compSnippetFromFile);
            }
            if (retval == 0) {
                StartEndPointer byteRange = this.getByteRange();
                StartEndPointer compByteRange = o.getByteRange();
                if (byteRange != null) {
                    return byteRange.compareTo(compByteRange);
                }
                if (o.getByteRange() == null) {
                    return 0;
                }
                return 1;
            }
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting compare for snippet", (Throwable)e);
            return -1;
        }
    }

    @Override
    public String toString() {
        StartEndPointer byteRange;
        SpdxFile snippetFromFile;
        Optional<String> name;
        try {
            name = this.getName();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting name", (Throwable)e);
            name = Optional.empty();
        }
        if (name.isPresent() && !name.get().isEmpty()) {
            return name.get();
        }
        StringBuilder sb = new StringBuilder();
        try {
            snippetFromFile = this.getSnippetFromFile();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting snippetFromFile", (Throwable)e);
            snippetFromFile = null;
        }
        if (snippetFromFile != null) {
            Optional<String> fileName;
            try {
                fileName = snippetFromFile.getName();
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.warn("Error getting snippetFromFile fileName", (Throwable)e);
                fileName = Optional.empty();
            }
            if (fileName.isPresent() && !fileName.get().isEmpty()) {
                sb.append(fileName);
            } else {
                sb.append("FileID ");
                sb.append(snippetFromFile.getId());
            }
            sb.append(": ");
        }
        try {
            byteRange = this.getByteRange();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting byteRange", (Throwable)e);
            byteRange = null;
        }
        if (byteRange != null) {
            sb.append(byteRange.toString());
        } else {
            sb.append("[No byte range set]");
        }
        return sb.toString();
    }

    public static class SpdxSnippetBuilder {
        IModelStore modelStore;
        String documentUri;
        String id;
        ModelCopyManager copyManager;
        String name;
        AnyLicenseInfo concludedLicense;
        Collection<AnyLicenseInfo> licenseInfosFromFile;
        String copyrightText;
        SpdxFile snippetFromFile;
        int startByte;
        int endByte;
        Collection<Annotation> annotations = new ArrayList<Annotation>();
        Collection<Relationship> relationships = new ArrayList<Relationship>();
        String comment = null;
        String licenseComments = null;
        int startLine = -1;
        int endLine = -1;

        public SpdxSnippetBuilder(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, String name, AnyLicenseInfo concludedLicense, Collection<AnyLicenseInfo> licenseInfosFromFile, String copyrightText, SpdxFile snippetFromFile, int startByte, int endByte) {
            Objects.requireNonNull(modelStore, "Model store can not be null");
            Objects.requireNonNull(documentUri, "Document URI can not be null");
            Objects.requireNonNull(id, "ID can not be null");
            Objects.requireNonNull(name, "Name can not be null");
            Objects.requireNonNull(concludedLicense, "Concluded license can not be null");
            Objects.requireNonNull(licenseInfosFromFile, "License info from file can not be null");
            Objects.requireNonNull(copyrightText, "Copyright text can not be null");
            Objects.requireNonNull(snippetFromFile, "Snippet from file can not be null");
            this.modelStore = modelStore;
            this.documentUri = documentUri;
            this.id = id;
            this.name = name;
            this.concludedLicense = concludedLicense;
            this.licenseInfosFromFile = licenseInfosFromFile;
            this.copyrightText = copyrightText;
            this.startByte = startByte;
            this.endByte = endByte;
            this.snippetFromFile = snippetFromFile;
            this.copyManager = copyManager;
        }

        public SpdxSnippetBuilder setAnnotations(Collection<Annotation> annotations) {
            Objects.requireNonNull(annotations, "Annotations can not be null");
            this.annotations = annotations;
            return this;
        }

        public SpdxSnippetBuilder addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation, "Annotation can not be null");
            this.annotations.add(annotation);
            return this;
        }

        public SpdxSnippetBuilder setRelationship(Collection<Relationship> relationships) {
            Objects.requireNonNull(relationships, "Relationships can not be null");
            this.relationships = relationships;
            return this;
        }

        public SpdxSnippetBuilder addRelationship(Relationship relationship) {
            Objects.requireNonNull(relationship, "Relationship can not be null");
            this.relationships.add(relationship);
            return this;
        }

        public SpdxSnippetBuilder setComment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public SpdxSnippetBuilder setLicenseComments(@Nullable String licenseComments) {
            this.licenseComments = licenseComments;
            return this;
        }

        public SpdxSnippetBuilder setLineRange(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
            return this;
        }

        public SpdxSnippet build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(this.documentUri, false);
            try {
                SpdxSnippet spdxSnippet = new SpdxSnippet(this);
                return spdxSnippet;
            }
            finally {
                this.modelStore.leaveCriticalSection(lock);
            }
        }
    }
}

