/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.parquet.LeafFilterFactory;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;

final class SearchArgumentImpl
implements SearchArgument {
    public static final Log LOG = LogFactory.getLog(SearchArgumentImpl.class);
    private final List<PredicateLeaf> leaves;
    private final ExpressionTree expression;

    SearchArgumentImpl(ExprNodeGenericFuncDesc expr) {
        if (expr == null) {
            this.leaves = new ArrayList<PredicateLeaf>();
            this.expression = null;
        } else {
            ExpressionBuilder builder = new ExpressionBuilder();
            this.expression = builder.expression(expr);
            this.leaves = builder.getLeaves();
        }
    }

    SearchArgumentImpl() {
        this.leaves = null;
        this.expression = null;
    }

    SearchArgumentImpl(ExpressionTree expression, List<PredicateLeaf> leaves) {
        this.expression = expression;
        this.leaves = leaves;
    }

    @Override
    public List<PredicateLeaf> getLeaves() {
        return this.leaves;
    }

    @Override
    public SearchArgument.TruthValue evaluate(SearchArgument.TruthValue[] leaves) {
        return this.expression == null ? SearchArgument.TruthValue.YES : this.expression.evaluate(leaves);
    }

    ExpressionTree getExpression() {
        return this.expression;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.leaves.size(); ++i) {
            buffer.append("leaf-");
            buffer.append(i);
            buffer.append(" = ");
            buffer.append(this.leaves.get(i).toString());
            buffer.append('\n');
        }
        buffer.append("expr = ");
        buffer.append(this.expression);
        return buffer.toString();
    }

    @Override
    public String toKryo() {
        Output out = new Output(4096, 0xA00000);
        new Kryo().writeObject(out, (Object)this);
        out.close();
        return Base64.encodeBase64String((byte[])out.toBytes());
    }

    static SearchArgument fromKryo(String value) {
        Input input = new Input(Base64.decodeBase64((String)value));
        return (SearchArgument)new Kryo().readObject(input, SearchArgumentImpl.class);
    }

    @Override
    public FilterPredicate toFilterPredicate() {
        return this.expression.translate(this.leaves);
    }

    public static SearchArgument.Builder newBuilder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements SearchArgument.Builder {
        private final Deque<ExpressionTree> currentTree = new ArrayDeque<ExpressionTree>();
        private final List<PredicateLeaf> leaves = new ArrayList<PredicateLeaf>();
        private ExpressionTree root = null;

        private BuilderImpl() {
        }

        @Override
        public SearchArgument.Builder startOr() {
            ExpressionTree node = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
            if (this.currentTree.size() != 0) {
                ExpressionTree parent = this.currentTree.getFirst();
                parent.children.add(node);
            }
            this.currentTree.addFirst(node);
            return this;
        }

        @Override
        public SearchArgument.Builder startAnd() {
            ExpressionTree node = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
            if (this.currentTree.size() != 0) {
                ExpressionTree parent = this.currentTree.getFirst();
                parent.children.add(node);
            }
            this.currentTree.addFirst(node);
            return this;
        }

        @Override
        public SearchArgument.Builder startNot() {
            ExpressionTree node = new ExpressionTree(ExpressionTree.Operator.NOT, new ExpressionTree[0]);
            if (this.currentTree.size() != 0) {
                ExpressionTree parent = this.currentTree.getFirst();
                parent.children.add(node);
            }
            this.currentTree.addFirst(node);
            return this;
        }

        @Override
        public SearchArgument.Builder end() {
            this.root = this.currentTree.removeFirst();
            if (this.root.children.size() == 0) {
                throw new IllegalArgumentException("Can't create expression " + this.root + " with no children.");
            }
            if (this.root.operator == ExpressionTree.Operator.NOT && this.root.children.size() != 1) {
                throw new IllegalArgumentException("Can't create not expression " + this.root + " with more than 1 child.");
            }
            return this;
        }

        private static Object boxLiteral(Object literal) {
            if (literal instanceof String || literal instanceof Long || literal instanceof Double || literal instanceof DateWritable || literal instanceof Timestamp || literal instanceof HiveDecimal || literal instanceof BigDecimal || literal instanceof Boolean) {
                return literal;
            }
            if (literal instanceof HiveChar || literal instanceof HiveVarchar) {
                return StringUtils.stripEnd((String)literal.toString(), null);
            }
            if (literal instanceof Byte || literal instanceof Short || literal instanceof Integer) {
                return ((Number)literal).longValue();
            }
            if (literal instanceof Float) {
                return Double.parseDouble(literal.toString());
            }
            throw new IllegalArgumentException("Unknown type for literal " + literal);
        }

        private static PredicateLeaf.Type getType(Object literal) {
            if (literal instanceof Byte || literal instanceof Short || literal instanceof Integer) {
                return PredicateLeaf.Type.INTEGER;
            }
            if (literal instanceof Long) {
                return PredicateLeaf.Type.LONG;
            }
            if (literal instanceof HiveChar || literal instanceof HiveVarchar || literal instanceof String) {
                return PredicateLeaf.Type.STRING;
            }
            if (literal instanceof Float || literal instanceof Double) {
                return PredicateLeaf.Type.FLOAT;
            }
            if (literal instanceof DateWritable) {
                return PredicateLeaf.Type.DATE;
            }
            if (literal instanceof Timestamp) {
                return PredicateLeaf.Type.TIMESTAMP;
            }
            if (literal instanceof HiveDecimal || literal instanceof BigDecimal) {
                return PredicateLeaf.Type.DECIMAL;
            }
            if (literal instanceof Boolean) {
                return PredicateLeaf.Type.BOOLEAN;
            }
            throw new IllegalArgumentException("Unknown type for literal " + literal);
        }

        @Override
        public SearchArgument.Builder lessThan(String column, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            Object box = BuilderImpl.boxLiteral(literal);
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.LESS_THAN, BuilderImpl.getType(box), column, box, null);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument.Builder lessThanEquals(String column, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            Object box = BuilderImpl.boxLiteral(literal);
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.LESS_THAN_EQUALS, BuilderImpl.getType(box), column, box, null);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument.Builder equals(String column, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            Object box = BuilderImpl.boxLiteral(literal);
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.EQUALS, BuilderImpl.getType(box), column, box, null);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument.Builder nullSafeEquals(String column, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            Object box = BuilderImpl.boxLiteral(literal);
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.NULL_SAFE_EQUALS, BuilderImpl.getType(box), column, box, null);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument.Builder in(String column, Object ... literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (literal.length == 0) {
                throw new IllegalArgumentException("Can't create in expression with no arguments");
            }
            ArrayList<Object> argList = new ArrayList<Object>();
            for (Object lit : literal) {
                argList.add(BuilderImpl.boxLiteral(lit));
            }
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.IN, BuilderImpl.getType(argList.get(0)), column, null, argList);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument.Builder isNull(String column) {
            ExpressionTree parent = this.currentTree.getFirst();
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.IS_NULL, PredicateLeaf.Type.STRING, column, null, null);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument.Builder between(String column, Object lower, Object upper) {
            ExpressionTree parent = this.currentTree.getFirst();
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(BuilderImpl.boxLiteral(lower));
            argList.add(BuilderImpl.boxLiteral(upper));
            PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.BETWEEN, BuilderImpl.getType(argList.get(0)), column, null, argList);
            this.leaves.add(leaf);
            parent.children.add(new ExpressionTree(this.leaves.size() - 1));
            return this;
        }

        @Override
        public SearchArgument build() {
            if (this.currentTree.size() != 0) {
                throw new IllegalArgumentException("Failed to end " + this.currentTree.size() + " operations.");
            }
            ExpressionBuilder internal = new ExpressionBuilder();
            ExpressionTree normalized = internal.expression(this.root, this.leaves);
            return new SearchArgumentImpl(normalized, internal.getLeaves());
        }
    }

    static class ExpressionBuilder {
        private static final int CNF_COMBINATIONS_THRESHOLD = 256;
        private final List<PredicateLeaf> leaves = new ArrayList<PredicateLeaf>();

        ExpressionBuilder() {
        }

        private static PredicateLeaf.Type getType(ExprNodeDesc expr) {
            TypeInfo type = expr.getTypeInfo();
            if (type.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                switch (((PrimitiveTypeInfo)type).getPrimitiveCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        return PredicateLeaf.Type.INTEGER;
                    }
                    case LONG: {
                        return PredicateLeaf.Type.LONG;
                    }
                    case CHAR: 
                    case VARCHAR: 
                    case STRING: {
                        return PredicateLeaf.Type.STRING;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return PredicateLeaf.Type.FLOAT;
                    }
                    case DATE: {
                        return PredicateLeaf.Type.DATE;
                    }
                    case TIMESTAMP: {
                        return PredicateLeaf.Type.TIMESTAMP;
                    }
                    case DECIMAL: {
                        return PredicateLeaf.Type.DECIMAL;
                    }
                    case BOOLEAN: {
                        return PredicateLeaf.Type.BOOLEAN;
                    }
                }
            }
            return null;
        }

        private static String getColumnName(ExprNodeGenericFuncDesc expr, int variable) {
            List<ExprNodeDesc> children = expr.getChildren();
            if (variable < 0 || variable >= children.size()) {
                return null;
            }
            ExprNodeDesc child = children.get(variable);
            if (child instanceof ExprNodeColumnDesc) {
                return ((ExprNodeColumnDesc)child).getColumn();
            }
            return null;
        }

        private static Object boxLiteral(ExprNodeConstantDesc lit) {
            switch (ExpressionBuilder.getType(lit)) {
                case INTEGER: {
                    return ((Number)lit.getValue()).intValue();
                }
                case LONG: {
                    return ((Number)lit.getValue()).longValue();
                }
                case STRING: {
                    return StringUtils.stripEnd((String)lit.getValue().toString(), null);
                }
                case FLOAT: {
                    return Double.parseDouble(lit.getValue().toString());
                }
                case DATE: 
                case TIMESTAMP: 
                case DECIMAL: 
                case BOOLEAN: {
                    return lit;
                }
            }
            throw new IllegalArgumentException("Unknown literal " + (Object)((Object)ExpressionBuilder.getType(lit)));
        }

        private static Object getLiteral(ExprNodeGenericFuncDesc expr) {
            Object result = null;
            List<ExprNodeDesc> children = expr.getChildren();
            if (children.size() != 2) {
                return null;
            }
            for (ExprNodeDesc child : children) {
                if (!(child instanceof ExprNodeConstantDesc)) continue;
                if (result != null) {
                    return null;
                }
                result = ExpressionBuilder.boxLiteral((ExprNodeConstantDesc)child);
            }
            return result;
        }

        private static List<Object> getLiteralList(ExprNodeGenericFuncDesc expr, int start) {
            ArrayList<Object> result = new ArrayList<Object>();
            List<ExprNodeDesc> children = expr.getChildren();
            for (ExprNodeDesc child : children.subList(start, children.size())) {
                if (child instanceof ExprNodeConstantDesc) {
                    result.add(ExpressionBuilder.boxLiteral((ExprNodeConstantDesc)child));
                    continue;
                }
                return null;
            }
            return result;
        }

        private ExpressionTree createLeaf(PredicateLeaf.Operator operator, ExprNodeGenericFuncDesc expression, List<PredicateLeaf> leafCache, int variable) {
            String columnName = ExpressionBuilder.getColumnName(expression, variable);
            if (columnName == null) {
                return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
            }
            PredicateLeaf.Type type = ExpressionBuilder.getType(expression.getChildren().get(variable));
            if (type == null) {
                return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
            }
            Object literal = null;
            List<Object> literalList = null;
            switch (operator) {
                case IS_NULL: {
                    break;
                }
                case IN: 
                case BETWEEN: {
                    literalList = ExpressionBuilder.getLiteralList(expression, variable + 1);
                    if (literalList != null) break;
                    return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
                }
                default: {
                    literal = ExpressionBuilder.getLiteral(expression);
                    if (literal != null) break;
                    return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
                }
            }
            boolean needSwap = false;
            if (variable != 0) {
                if (operator == PredicateLeaf.Operator.LESS_THAN) {
                    needSwap = true;
                    operator = PredicateLeaf.Operator.LESS_THAN_EQUALS;
                } else if (operator == PredicateLeaf.Operator.LESS_THAN_EQUALS) {
                    needSwap = true;
                    operator = PredicateLeaf.Operator.LESS_THAN;
                }
            }
            leafCache.add(new PredicateLeafImpl(operator, type, columnName, literal, literalList));
            ExpressionTree result = new ExpressionTree(leafCache.size() - 1);
            if (needSwap) {
                result = this.negate(result);
            }
            return result;
        }

        private int findVariable(ExprNodeDesc expr) {
            int result = -1;
            List<ExprNodeDesc> children = expr.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                ExprNodeDesc child = children.get(i);
                if (!(child instanceof ExprNodeColumnDesc)) continue;
                if (result != -1) {
                    return -1;
                }
                result = i;
            }
            return result;
        }

        private ExpressionTree createLeaf(PredicateLeaf.Operator operator, ExprNodeGenericFuncDesc expression, List<PredicateLeaf> leafCache) {
            return this.createLeaf(operator, expression, leafCache, this.findVariable(expression));
        }

        private ExpressionTree negate(ExpressionTree expr) {
            ExpressionTree result = new ExpressionTree(ExpressionTree.Operator.NOT, new ExpressionTree[0]);
            result.children.add(expr);
            return result;
        }

        private void addChildren(ExpressionTree result, ExprNodeGenericFuncDesc node, List<PredicateLeaf> leafCache) {
            for (ExprNodeDesc child : node.getChildren()) {
                result.children.add(this.parse(child, leafCache));
            }
        }

        private ExpressionTree parse(ExprNodeDesc expression, List<PredicateLeaf> leafCache) {
            ExpressionTree result;
            if (expression.getClass() != ExprNodeGenericFuncDesc.class) {
                return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
            }
            ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)expression;
            Class<?> op = expr.getGenericUDF().getClass();
            if (op == GenericUDFOPOr.class) {
                result = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
                this.addChildren(result, expr, leafCache);
            } else if (op == GenericUDFOPAnd.class) {
                result = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
                this.addChildren(result, expr, leafCache);
            } else if (op == GenericUDFOPNot.class) {
                result = new ExpressionTree(ExpressionTree.Operator.NOT, new ExpressionTree[0]);
                this.addChildren(result, expr, leafCache);
            } else {
                result = op == GenericUDFOPEqual.class ? this.createLeaf(PredicateLeaf.Operator.EQUALS, expr, leafCache) : (op == GenericUDFOPNotEqual.class ? this.negate(this.createLeaf(PredicateLeaf.Operator.EQUALS, expr, leafCache)) : (op == GenericUDFOPEqualNS.class ? this.createLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, expr, leafCache) : (op == GenericUDFOPGreaterThan.class ? this.negate(this.createLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, expr, leafCache)) : (op == GenericUDFOPEqualOrGreaterThan.class ? this.negate(this.createLeaf(PredicateLeaf.Operator.LESS_THAN, expr, leafCache)) : (op == GenericUDFOPLessThan.class ? this.createLeaf(PredicateLeaf.Operator.LESS_THAN, expr, leafCache) : (op == GenericUDFOPEqualOrLessThan.class ? this.createLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, expr, leafCache) : (op == GenericUDFIn.class ? this.createLeaf(PredicateLeaf.Operator.IN, expr, leafCache, 0) : (op == GenericUDFBetween.class ? this.createLeaf(PredicateLeaf.Operator.BETWEEN, expr, leafCache, 1) : (op == GenericUDFOPNull.class ? this.createLeaf(PredicateLeaf.Operator.IS_NULL, expr, leafCache, 0) : (op == GenericUDFOPNotNull.class ? this.negate(this.createLeaf(PredicateLeaf.Operator.IS_NULL, expr, leafCache, 0)) : new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL)))))))))));
            }
            return result;
        }

        static ExpressionTree pushDownNot(ExpressionTree root) {
            block11: {
                block10: {
                    if (root.operator != ExpressionTree.Operator.NOT) break block10;
                    ExpressionTree child = (ExpressionTree)root.children.get(0);
                    switch (child.operator) {
                        case NOT: {
                            return ExpressionBuilder.pushDownNot((ExpressionTree)child.children.get(0));
                        }
                        case CONSTANT: {
                            return new ExpressionTree(child.constant.not());
                        }
                        case AND: {
                            root = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
                            for (ExpressionTree kid : child.children) {
                                root.children.add(ExpressionBuilder.pushDownNot(new ExpressionTree(ExpressionTree.Operator.NOT, kid)));
                            }
                            break block11;
                        }
                        case OR: {
                            root = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
                            for (ExpressionTree kid : child.children) {
                                root.children.add(ExpressionBuilder.pushDownNot(new ExpressionTree(ExpressionTree.Operator.NOT, kid)));
                            }
                            break block11;
                        }
                    }
                    break block11;
                }
                if (root.children != null) {
                    for (int i = 0; i < root.children.size(); ++i) {
                        root.children.set(i, ExpressionBuilder.pushDownNot((ExpressionTree)root.children.get(i)));
                    }
                }
            }
            return root;
        }

        static ExpressionTree foldMaybe(ExpressionTree expr) {
            if (expr.children != null) {
                block4: for (int i = 0; i < expr.children.size(); ++i) {
                    ExpressionTree child = ExpressionBuilder.foldMaybe((ExpressionTree)expr.children.get(i));
                    if (child.constant == SearchArgument.TruthValue.YES_NO_NULL) {
                        switch (expr.operator) {
                            case AND: {
                                expr.children.remove(i);
                                --i;
                                continue block4;
                            }
                            case OR: {
                                return child;
                            }
                            default: {
                                throw new IllegalStateException("Got a maybe as child of " + expr);
                            }
                        }
                    }
                    expr.children.set(i, child);
                }
                if (expr.children.isEmpty()) {
                    return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
                }
            }
            return expr;
        }

        private static void generateAllCombinations(List<ExpressionTree> result, List<ExpressionTree> andList, List<ExpressionTree> nonAndList) {
            List kids = andList.get(0).children;
            if (result.isEmpty()) {
                for (ExpressionTree kid : kids) {
                    ExpressionTree or = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
                    result.add(or);
                    for (ExpressionTree node : nonAndList) {
                        or.children.add(new ExpressionTree(node));
                    }
                    or.children.add(kid);
                }
            } else {
                ArrayList<ExpressionTree> work = new ArrayList<ExpressionTree>(result);
                result.clear();
                for (ExpressionTree kid : kids) {
                    for (ExpressionTree or : work) {
                        ExpressionTree copy = new ExpressionTree(or);
                        copy.children.add(kid);
                        result.add(copy);
                    }
                }
            }
            if (andList.size() > 1) {
                ExpressionBuilder.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
            }
        }

        static ExpressionTree convertToCNF(ExpressionTree root) {
            if (root.children != null) {
                int size = root.children.size();
                for (int i = 0; i < size; ++i) {
                    root.children.set(i, ExpressionBuilder.convertToCNF((ExpressionTree)root.children.get(i)));
                }
                if (root.operator == ExpressionTree.Operator.OR) {
                    ArrayList<ExpressionTree> nonAndList = new ArrayList<ExpressionTree>();
                    ArrayList<ExpressionTree> andList = new ArrayList<ExpressionTree>();
                    for (ExpressionTree child : root.children) {
                        if (child.operator == ExpressionTree.Operator.AND) {
                            andList.add(child);
                            continue;
                        }
                        if (child.operator == ExpressionTree.Operator.OR) {
                            for (ExpressionTree grandkid : child.children) {
                                nonAndList.add(grandkid);
                            }
                            continue;
                        }
                        nonAndList.add(child);
                    }
                    if (!andList.isEmpty()) {
                        if (ExpressionBuilder.checkCombinationsThreshold(andList)) {
                            root = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
                            ExpressionBuilder.generateAllCombinations(root.children, andList, nonAndList);
                        } else {
                            root = new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
                        }
                    }
                }
            }
            return root;
        }

        private static boolean checkCombinationsThreshold(List<ExpressionTree> andList) {
            int numComb = 1;
            for (ExpressionTree tree : andList) {
                if ((numComb *= tree.children.size()) <= 256) continue;
                return false;
            }
            return true;
        }

        static ExpressionTree flatten(ExpressionTree root) {
            if (root.children != null) {
                for (int i = 0; i < root.children.size(); ++i) {
                    ExpressionTree child = ExpressionBuilder.flatten((ExpressionTree)root.children.get(i));
                    if (child.operator == root.operator && child.operator != ExpressionTree.Operator.NOT) {
                        boolean first = true;
                        for (ExpressionTree grandkid : child.children) {
                            if (first) {
                                first = false;
                                root.children.set(i, grandkid);
                                continue;
                            }
                            root.children.add(++i, grandkid);
                        }
                        continue;
                    }
                    root.children.set(i, child);
                }
                if ((root.operator == ExpressionTree.Operator.OR || root.operator == ExpressionTree.Operator.AND) && root.children.size() == 1) {
                    return (ExpressionTree)root.children.get(0);
                }
            }
            return root;
        }

        private ExpressionTree buildLeafList(ExpressionTree expr, List<PredicateLeaf> leafCache, Map<PredicateLeaf, ExpressionTree> lookup) {
            if (expr.children != null) {
                for (int i = 0; i < expr.children.size(); ++i) {
                    expr.children.set(i, this.buildLeafList((ExpressionTree)expr.children.get(i), leafCache, lookup));
                }
            } else if (expr.operator == ExpressionTree.Operator.LEAF) {
                PredicateLeaf leaf = leafCache.get(expr.leaf);
                ExpressionTree val = lookup.get(leaf);
                if (val == null) {
                    val = new ExpressionTree(this.leaves.size());
                    lookup.put(leaf, val);
                    this.leaves.add(leaf);
                }
                return val;
            }
            return expr;
        }

        ExpressionTree expression(ExprNodeGenericFuncDesc expression) {
            ArrayList<PredicateLeaf> leafCache = new ArrayList<PredicateLeaf>();
            ExpressionTree expr = this.parse(expression, leafCache);
            return this.expression(expr, leafCache);
        }

        ExpressionTree expression(ExpressionTree expr, List<PredicateLeaf> leaves) {
            expr = ExpressionBuilder.pushDownNot(expr);
            expr = ExpressionBuilder.foldMaybe(expr);
            expr = ExpressionBuilder.flatten(expr);
            expr = ExpressionBuilder.convertToCNF(expr);
            expr = ExpressionBuilder.flatten(expr);
            expr = this.buildLeafList(expr, leaves, new HashMap<PredicateLeaf, ExpressionTree>());
            return expr;
        }

        List<PredicateLeaf> getLeaves() {
            return this.leaves;
        }
    }

    static class ExpressionTree {
        private final Operator operator;
        private final List<ExpressionTree> children;
        private final int leaf;
        private final SearchArgument.TruthValue constant;

        ExpressionTree() {
            this.operator = null;
            this.children = null;
            this.leaf = 0;
            this.constant = null;
        }

        ExpressionTree(Operator op, ExpressionTree ... kids) {
            this.operator = op;
            this.children = new ArrayList<ExpressionTree>();
            this.leaf = -1;
            this.constant = null;
            Collections.addAll(this.children, kids);
        }

        ExpressionTree(int leaf) {
            this.operator = Operator.LEAF;
            this.children = null;
            this.leaf = leaf;
            this.constant = null;
        }

        ExpressionTree(SearchArgument.TruthValue constant) {
            this.operator = Operator.CONSTANT;
            this.children = null;
            this.leaf = -1;
            this.constant = constant;
        }

        ExpressionTree(ExpressionTree other) {
            this.operator = other.operator;
            if (other.children == null) {
                this.children = null;
            } else {
                this.children = new ArrayList<ExpressionTree>();
                for (ExpressionTree child : other.children) {
                    this.children.add(new ExpressionTree(child));
                }
            }
            this.leaf = other.leaf;
            this.constant = other.constant;
        }

        SearchArgument.TruthValue evaluate(SearchArgument.TruthValue[] leaves) {
            SearchArgument.TruthValue result = null;
            switch (this.operator) {
                case OR: {
                    for (ExpressionTree child : this.children) {
                        result = child.evaluate(leaves).or(result);
                    }
                    return result;
                }
                case AND: {
                    for (ExpressionTree child : this.children) {
                        result = child.evaluate(leaves).and(result);
                    }
                    return result;
                }
                case NOT: {
                    return this.children.get(0).evaluate(leaves).not();
                }
                case LEAF: {
                    return leaves[this.leaf];
                }
                case CONSTANT: {
                    return this.constant;
                }
            }
            throw new IllegalStateException("Unknown operator: " + (Object)((Object)this.operator));
        }

        FilterPredicate translate(List<PredicateLeaf> leafs) {
            FilterPredicate p = null;
            switch (this.operator) {
                case OR: {
                    for (ExpressionTree child : this.children) {
                        if (p == null) {
                            p = child.translate(leafs);
                            continue;
                        }
                        FilterPredicate right = child.translate(leafs);
                        if (right == null) continue;
                        p = FilterApi.or((FilterPredicate)p, (FilterPredicate)right);
                    }
                    return p;
                }
                case AND: {
                    for (ExpressionTree child : this.children) {
                        if (p == null) {
                            p = child.translate(leafs);
                            continue;
                        }
                        FilterPredicate right = child.translate(leafs);
                        if (right == null) continue;
                        p = FilterApi.and((FilterPredicate)p, (FilterPredicate)right);
                    }
                    return p;
                }
                case NOT: {
                    FilterPredicate op = this.children.get(0).translate(leafs);
                    if (op != null) {
                        return FilterApi.not((FilterPredicate)op);
                    }
                    return null;
                }
                case LEAF: {
                    return this.buildFilterPredicateFromPredicateLeaf(leafs.get(this.leaf));
                }
                case CONSTANT: {
                    return null;
                }
            }
            throw new IllegalStateException("Unknown operator: " + (Object)((Object)this.operator));
        }

        private FilterPredicate buildFilterPredicateFromPredicateLeaf(PredicateLeaf leaf) {
            LeafFilterFactory leafFilterFactory = new LeafFilterFactory();
            try {
                FilterPredicateLeafBuilder builder = leafFilterFactory.getLeafFilterBuilderByType(leaf.getType());
                if (builder == null) {
                    return null;
                }
                if (this.isMultiLiteralsOperator(leaf.getOperator())) {
                    return builder.buildPredicate(leaf.getOperator(), leaf.getLiteralList(), leaf.getColumnName());
                }
                return builder.buildPredict(leaf.getOperator(), leaf.getLiteral(), leaf.getColumnName());
            }
            catch (Exception e) {
                LOG.error((Object)("fail to build predicate filter leaf with errors" + e), (Throwable)e);
                return null;
            }
        }

        private boolean isMultiLiteralsOperator(PredicateLeaf.Operator op) {
            return op == PredicateLeaf.Operator.IN || op == PredicateLeaf.Operator.BETWEEN;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            switch (this.operator) {
                case OR: {
                    buffer.append("(or");
                    for (ExpressionTree child : this.children) {
                        buffer.append(' ');
                        buffer.append(child.toString());
                    }
                    buffer.append(')');
                    break;
                }
                case AND: {
                    buffer.append("(and");
                    for (ExpressionTree child : this.children) {
                        buffer.append(' ');
                        buffer.append(child.toString());
                    }
                    buffer.append(')');
                    break;
                }
                case NOT: {
                    buffer.append("(not ");
                    buffer.append(this.children.get(0));
                    buffer.append(')');
                    break;
                }
                case LEAF: {
                    buffer.append("leaf-");
                    buffer.append(this.leaf);
                    break;
                }
                case CONSTANT: {
                    buffer.append((Object)this.constant);
                }
            }
            return buffer.toString();
        }

        Operator getOperator() {
            return this.operator;
        }

        List<ExpressionTree> getChildren() {
            return this.children;
        }

        static enum Operator {
            OR,
            AND,
            NOT,
            LEAF,
            CONSTANT;

        }
    }

    static final class PredicateLeafImpl
    implements PredicateLeaf {
        private final PredicateLeaf.Operator operator;
        private final PredicateLeaf.Type type;
        private final String columnName;
        private final Object literal;
        private final List<Object> literalList;

        PredicateLeafImpl() {
            this.operator = null;
            this.type = null;
            this.columnName = null;
            this.literal = null;
            this.literalList = null;
        }

        PredicateLeafImpl(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal, List<Object> literalList) {
            this.operator = operator;
            this.type = type;
            this.columnName = columnName;
            this.literal = literal;
            this.literalList = literalList;
        }

        @Override
        public PredicateLeaf.Operator getOperator() {
            return this.operator;
        }

        @Override
        public PredicateLeaf.Type getType() {
            return this.type;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public Object getLiteral() {
            if (this.literal instanceof Date) {
                return new Timestamp(((Date)this.literal).getTime());
            }
            return this.literal;
        }

        @Override
        public List<Object> getLiteralList() {
            return this.literalList;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            buffer.append((Object)this.operator);
            buffer.append(' ');
            buffer.append(this.columnName);
            if (this.literal != null) {
                buffer.append(' ');
                buffer.append(this.literal);
            } else if (this.literalList != null) {
                for (Object lit : this.literalList) {
                    buffer.append(' ');
                    buffer.append(lit.toString());
                }
            }
            buffer.append(')');
            return buffer.toString();
        }

        private static boolean isEqual(Object left, Object right) {
            if (left == right) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            return left.equals(right);
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (other == this) {
                return true;
            }
            PredicateLeafImpl o = (PredicateLeafImpl)other;
            return this.operator == o.operator && this.type == o.type && this.columnName.equals(o.columnName) && PredicateLeafImpl.isEqual(this.literal, o.literal) && PredicateLeafImpl.isEqual(this.literalList, o.literalList);
        }

        public int hashCode() {
            return this.operator.hashCode() + this.type.hashCode() * 17 + this.columnName.hashCode() * 3 * 17 + (this.literal == null ? 0 : this.literal.hashCode()) * 101 * 3 * 17 + (this.literalList == null ? 0 : this.literalList.hashCode()) * 103 * 101 * 3 * 17;
        }
    }
}

