/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javaewah.EWAHCompressedBitmap;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapObjectInput;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapObjectOutput;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.LongWritable;

public abstract class AbstractGenericUDFEWAHBitmapBop
extends GenericUDF {
    protected final ArrayList<Object> ret = new ArrayList();
    private transient ObjectInspector b1OI;
    private final String name;

    AbstractGenericUDFEWAHBitmapBop(String name) {
        this.name = name;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function " + this.name + "(b1, b2) takes exactly 2 arguments");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.LIST.toString().toLowerCase() + "\" is expected at function " + this.name + ", but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.b1OI = (ListObjectInspector)arguments[0];
        if (!arguments[1].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(1, "\"" + ObjectInspector.Category.LIST.toString().toLowerCase() + "\" is expected at function " + this.name + ", but \"" + arguments[1].getTypeName() + "\" is found");
        }
        return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
    }

    protected abstract EWAHCompressedBitmap bitmapBop(EWAHCompressedBitmap var1, EWAHCompressedBitmap var2);

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        Object b1 = arguments[0].get();
        Object b2 = arguments[1].get();
        EWAHCompressedBitmap bitmap1 = this.wordArrayToBitmap(b1);
        EWAHCompressedBitmap bitmap2 = this.wordArrayToBitmap(b2);
        EWAHCompressedBitmap bitmapAnd = this.bitmapBop(bitmap1, bitmap2);
        BitmapObjectOutput bitmapObjOut = new BitmapObjectOutput();
        try {
            bitmapAnd.writeExternal((ObjectOutput)bitmapObjOut);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.ret.clear();
        List<LongWritable> retList = this.bitmapToWordArray(bitmapAnd);
        for (LongWritable l : retList) {
            this.ret.add(l);
        }
        return this.ret;
    }

    protected EWAHCompressedBitmap wordArrayToBitmap(Object b) {
        ListObjectInspector lloi = (ListObjectInspector)this.b1OI;
        int length = lloi.getListLength(b);
        ArrayList<LongWritable> bitmapArray = new ArrayList<LongWritable>();
        for (int i = 0; i < length; ++i) {
            long l = PrimitiveObjectInspectorUtils.getLong(lloi.getListElement(b, i), (PrimitiveObjectInspector)lloi.getListElementObjectInspector());
            bitmapArray.add(new LongWritable(l));
        }
        BitmapObjectInput bitmapObjIn = new BitmapObjectInput(bitmapArray);
        EWAHCompressedBitmap bitmap = new EWAHCompressedBitmap();
        try {
            bitmap.readExternal((ObjectInput)bitmapObjIn);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bitmap;
    }

    protected List<LongWritable> bitmapToWordArray(EWAHCompressedBitmap bitmap) {
        BitmapObjectOutput bitmapObjOut = new BitmapObjectOutput();
        try {
            bitmap.writeExternal((ObjectOutput)bitmapObjOut);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bitmapObjOut.list();
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        for (int i = 0; i < children.length; ++i) {
            sb.append(children[i]);
            if (i + 1 == children.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

