/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnStatsTask;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMRFileSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMROperator;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink2;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink3;
import org.apache.hadoop.hive.ql.optimizer.GenMRTableScan1;
import org.apache.hadoop.hive.ql.optimizer.GenMRUnion1;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.MapJoinFactory;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalOptimizer;
import org.apache.hadoop.hive.ql.parse.GenMapRedWalker;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.IndexUpdater;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;

public class MapReduceCompiler {
    protected final Log LOG = LogFactory.getLog(MapReduceCompiler.class);
    private Hive db;
    protected SessionState.LogHelper console;
    private HiveConf conf;

    public void init(HiveConf conf, SessionState.LogHelper console, Hive db) {
        this.conf = conf;
        this.db = db;
        this.console = console;
    }

    public void compile(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        Context ctx = pCtx.getContext();
        GlobalLimitCtx globalLimitCtx = pCtx.getGlobalLimitCtx();
        QB qb = pCtx.getQB();
        ArrayList<Task<MoveWork>> mvTask = new ArrayList<Task<MoveWork>>();
        List<LoadTableDesc> loadTableWork = pCtx.getLoadTableWork();
        List<LoadFileDesc> loadFileWork = pCtx.getLoadFileWork();
        boolean isCStats = qb.isAnalyzeRewrite();
        if (pCtx.getFetchTask() != null) {
            return;
        }
        if (pCtx.getQB().getIsQuery() && !isCStats) {
            if (!loadTableWork.isEmpty() || loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            LoadFileDesc loadFileDesc = loadFileWork.get(0);
            String cols = loadFileDesc.getColumns();
            String colTypes = loadFileDesc.getColumnTypes();
            TableDesc resultTab = pCtx.getFetchTabledesc();
            if (resultTab == null) {
                String resFileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat);
            }
            FetchWork fetch = new FetchWork(new Path(loadFileDesc.getSourceDir()).toString(), resultTab, qb.getParseInfo().getOuterQueryLimit());
            fetch.setSource(pCtx.getFetchSource());
            fetch.setSink(pCtx.getFetchSink());
            pCtx.setFetchTask((FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]));
            int fetchLimit = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVELIMITOPTMAXFETCH);
            if (globalLimitCtx.isEnable() && globalLimitCtx.getGlobalLimit() > fetchLimit) {
                this.LOG.info((Object)("For FetchTask, LIMIT " + globalLimitCtx.getGlobalLimit() + " > " + fetchLimit + ". Doesn't qualify limit optimiztion."));
                globalLimitCtx.disableOpt();
            }
        } else if (!isCStats) {
            for (LoadTableDesc ltd : loadTableWork) {
                Task<MoveWork> tsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false), this.conf, new Task[0]);
                mvTask.add(tsk);
                if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEINDEXAUTOUPDATE)) continue;
                IndexUpdater indexUpdater = new IndexUpdater(loadTableWork, inputs, (Configuration)this.conf);
                try {
                    List<Task<? extends Serializable>> indexUpdateTasks = indexUpdater.generateUpdateTasks();
                    for (Task<? extends Serializable> updateTask : indexUpdateTasks) {
                        tsk.addDependentTask(updateTask);
                    }
                }
                catch (HiveException e) {
                    this.console.printInfo("WARNING: could not auto-update stale indexes, which are not in sync");
                }
            }
            boolean oneLoadFile = true;
            for (LoadFileDesc lfd : loadFileWork) {
                if (qb.isCTAS()) {
                    assert (oneLoadFile);
                    String location = qb.getTableDesc().getLocation();
                    if (location == null) {
                        Path targetPath;
                        try {
                            Table dumpTable = this.db.newTable(qb.getTableDesc().getTableName());
                            if (!this.db.databaseExists(dumpTable.getDbName())) {
                                throw new SemanticException("ERROR: The database " + dumpTable.getDbName() + " does not exist.");
                            }
                            Warehouse wh = new Warehouse((Configuration)this.conf);
                            targetPath = wh.getTablePath(this.db.getDatabase(dumpTable.getDbName()), dumpTable.getTableName());
                        }
                        catch (HiveException e) {
                            throw new SemanticException(e);
                        }
                        catch (MetaException e) {
                            throw new SemanticException(e);
                        }
                        location = targetPath.toString();
                    }
                    lfd.setTargetDir(location);
                    oneLoadFile = false;
                }
                mvTask.add(TaskFactory.get(new MoveWork(null, null, null, lfd, false), this.conf, new Task[0]));
            }
        }
        ParseContext tempParseContext = this.getParseContext(pCtx, rootTasks);
        GenMRProcContext procCtx = new GenMRProcContext(this.conf, new HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>>(), tempParseContext, mvTask, rootTasks, new LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx>(), inputs, outputs);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp(new String("R1"), TableScanOperator.getOperatorName() + "%"), new GenMRTableScan1());
        opRules.put(new RuleRegExp(new String("R2"), TableScanOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new GenMRRedSink1());
        opRules.put(new RuleRegExp(new String("R3"), ReduceSinkOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new GenMRRedSink2());
        opRules.put(new RuleRegExp(new String("R4"), FileSinkOperator.getOperatorName() + "%"), new GenMRFileSink1());
        opRules.put(new RuleRegExp(new String("R5"), UnionOperator.getOperatorName() + "%"), new GenMRUnion1());
        opRules.put(new RuleRegExp(new String("R6"), UnionOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new GenMRRedSink3());
        opRules.put(new RuleRegExp(new String("R7"), MapJoinOperator.getOperatorName() + "%"), MapJoinFactory.getTableScanMapJoin());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new GenMROperator(), opRules, procCtx);
        GenMapRedWalker ogw = new GenMapRedWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        if (isCStats) {
            this.genColumnStatsTask(qb, loadTableWork, loadFileWork, rootTasks);
        }
        for (Task<? extends Serializable> rootTask : rootTasks) {
            this.breakTaskTree(rootTask);
        }
        for (Task<? extends Serializable> rootTask : rootTasks) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(rootTask);
        }
        for (Task<? extends Serializable> rootTask : rootTasks) {
            this.setInputFormat(rootTask);
        }
        PhysicalContext physicalContext = new PhysicalContext(this.conf, this.getParseContext(pCtx, rootTasks), ctx, rootTasks, pCtx.getFetchTask());
        PhysicalOptimizer physicalOptimizer = new PhysicalOptimizer(physicalContext, this.conf);
        physicalOptimizer.optimize();
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEJOBPROGRESS)) {
            for (Task<? extends Serializable> rootTask : rootTasks) {
                this.generateCountersTask(rootTask);
            }
        }
        this.decideExecMode(rootTasks, ctx, globalLimitCtx);
        if (qb.isCTAS()) {
            CreateTableDesc crtTblDesc = qb.getTableDesc();
            crtTblDesc.validate();
            outputs.clear();
            Task<DDLWork> crtTblTask = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc), this.conf, new Task[0]);
            HashSet<Task<? extends Serializable>> leaves = new HashSet<Task<? extends Serializable>>();
            this.getLeafTasks(rootTasks, leaves);
            assert (leaves.size() > 0);
            for (Task<? extends Serializable> task : leaves) {
                if (task instanceof StatsTask) {
                    for (Task<Serializable> parentOfStatsTask : task.getParentTasks()) {
                        parentOfStatsTask.addDependentTask(crtTblTask);
                    }
                    for (Task<Serializable> parentOfCrtTblTask : crtTblTask.getParentTasks()) {
                        parentOfCrtTblTask.removeDependentTask(task);
                    }
                    crtTblTask.addDependentTask(task);
                    continue;
                }
                task.addDependentTask(crtTblTask);
            }
        }
        if (globalLimitCtx.isEnable() && pCtx.getFetchTask() != null) {
            this.LOG.info((Object)("set least row check for FetchTask: " + globalLimitCtx.getGlobalLimit()));
            ((FetchWork)pCtx.getFetchTask().getWork()).setLeastNumRows(globalLimitCtx.getGlobalLimit());
        }
        if (globalLimitCtx.isEnable() && globalLimitCtx.getLastReduceLimitDesc() != null) {
            this.LOG.info((Object)("set least row check for LimitDesc: " + globalLimitCtx.getGlobalLimit()));
            globalLimitCtx.getLastReduceLimitDesc().setLeastRows(globalLimitCtx.getGlobalLimit());
            List<ExecDriver> mrTasks = Utilities.getMRTasks(rootTasks);
            for (ExecDriver tsk : mrTasks) {
                tsk.setRetryCmdWhenFail(true);
            }
        }
    }

    private void setInputFormat(MapWork work, Operator<? extends OperatorDesc> op) {
        if (op.isUseBucketizedHiveInputFormat()) {
            work.setUseBucketizedHiveInputFormat(true);
            return;
        }
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
                this.setInputFormat(work, childOp);
            }
        }
    }

    private void setInputFormat(Task<? extends Serializable> task) {
        if (task instanceof ExecDriver) {
            MapWork work = ((MapredWork)task.getWork()).getMapWork();
            LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap = work.getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator op : ((HashMap)opMap).values()) {
                    this.setInputFormat(work, op);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<? extends Serializable> tsk : listTasks) {
                this.setInputFormat(tsk);
            }
        }
        if (task.getChildTasks() != null) {
            for (Task<Serializable> childTask : task.getChildTasks()) {
                this.setInputFormat(childTask);
            }
        }
    }

    private void generateCountersTask(Task<? extends Serializable> task) {
        if (task instanceof ExecDriver) {
            LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap = ((MapredWork)task.getWork()).getMapWork().getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator operator : ((HashMap)opMap).values()) {
                    this.generateCountersOperator(operator);
                }
            }
            if (((MapredWork)task.getWork()).getReduceWork() != null) {
                Operator<?> reducer = ((MapredWork)task.getWork()).getReduceWork().getReducer();
                this.LOG.info((Object)("Generating counters for operator " + reducer));
                this.generateCountersOperator(reducer);
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<Serializable> task2 : listTasks) {
                this.generateCountersTask(task2);
            }
        }
        Operator.resetLastEnumUsed();
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.generateCountersTask(childTask);
        }
    }

    private void generateCountersOperator(Operator<? extends OperatorDesc> op) {
        op.assignCounterNameToEnum();
        if (op.getChildOperators() == null) {
            return;
        }
        for (Operator<OperatorDesc> child : op.getChildOperators()) {
            this.generateCountersOperator(child);
        }
    }

    public ParseContext getParseContext(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks) {
        return new ParseContext(this.conf, pCtx.getQB(), pCtx.getParseTree(), pCtx.getOpToPartPruner(), pCtx.getOpToPartList(), pCtx.getTopOps(), pCtx.getTopSelOps(), pCtx.getOpParseCtx(), pCtx.getJoinContext(), pCtx.getSmbMapJoinContext(), pCtx.getTopToTable(), pCtx.getTopToProps(), pCtx.getFsopToTable(), pCtx.getLoadTableWork(), pCtx.getLoadFileWork(), pCtx.getContext(), pCtx.getIdToTableNameMap(), pCtx.getDestTableId(), pCtx.getUCtx(), pCtx.getListMapJoinOpsNoReducer(), pCtx.getGroupOpToInputTables(), pCtx.getPrunedPartitions(), pCtx.getOpToSamplePruner(), pCtx.getGlobalLimitCtx(), pCtx.getNameToSplitSample(), pCtx.getSemanticInputs(), rootTasks, pCtx.getOpToPartToSkewedPruner(), pCtx.getViewAliasToInput(), pCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting(), pCtx.getQueryProperties());
    }

    private void breakTaskTree(Task<? extends Serializable> task) {
        if (task instanceof ExecDriver) {
            LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap = ((MapredWork)task.getWork()).getMapWork().getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator operator : ((HashMap)opMap).values()) {
                    this.breakOperatorTree(operator);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<Serializable> task2 : listTasks) {
                this.breakTaskTree(task2);
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.breakTaskTree(childTask);
        }
    }

    private void breakOperatorTree(Operator<? extends OperatorDesc> topOp) {
        if (topOp instanceof ReduceSinkOperator) {
            topOp.setChildOperators(null);
        }
        if (topOp.getChildOperators() == null) {
            return;
        }
        for (Operator<OperatorDesc> op : topOp.getChildOperators()) {
            this.breakOperatorTree(op);
        }
    }

    private void genColumnStatsTask(QB qb, List<LoadTableDesc> loadTableWork, List<LoadFileDesc> loadFileWork, List<Task<? extends Serializable>> rootTasks) {
        QBParseInfo qbParseInfo = qb.getParseInfo();
        ColumnStatsTask cStatsTask = null;
        ColumnStatsWork cStatsWork = null;
        FetchWork fetch = null;
        String tableName = qbParseInfo.getTableName();
        String partName = qbParseInfo.getPartName();
        List<String> colName = qbParseInfo.getColName();
        List<String> colType = qbParseInfo.getColType();
        boolean isTblLevel = qbParseInfo.isTblLvl();
        String cols = loadFileWork.get(0).getColumns();
        String colTypes = loadFileWork.get(0).getColumnTypes();
        String resFileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
        TableDesc resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat);
        fetch = new FetchWork(new Path(loadFileWork.get(0).getSourceDir()).toString(), resultTab, qb.getParseInfo().getOuterQueryLimit());
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tableName, partName, colName, colType, isTblLevel);
        cStatsWork = new ColumnStatsWork(fetch, cStatsDesc);
        cStatsTask = (ColumnStatsTask)TaskFactory.get(cStatsWork, this.conf, new Task[0]);
        rootTasks.add(cStatsTask);
    }

    private void getLeafTasks(List<Task<? extends Serializable>> rootTasks, HashSet<Task<? extends Serializable>> leaves) {
        for (Task<? extends Serializable> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<? extends Serializable> task, HashSet<Task<? extends Serializable>> leaves) {
        if (task.getDependentTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getDependentTasks(), leaves);
        }
    }

    private static int getNumberOfReducers(MapredWork mrwork, HiveConf conf) {
        if (mrwork.getReduceWork() == null) {
            return 0;
        }
        if (mrwork.getReduceWork().getNumReduceTasks() >= 0) {
            return mrwork.getReduceWork().getNumReduceTasks();
        }
        return conf.getIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS);
    }

    private void decideExecMode(List<Task<? extends Serializable>> rootTasks, Context ctx, GlobalLimitCtx globalLimitCtx) throws SemanticException {
        if (ctx.getExplain()) {
            return;
        }
        if (ctx.isLocalOnlyExecutionMode() || !this.conf.getBoolVar(HiveConf.ConfVars.LOCALMODEAUTO)) {
            return;
        }
        final Context lCtx = ctx;
        PathFilter p = new PathFilter(){

            public boolean accept(Path file) {
                return !lCtx.isMRTmpFileURI(file.toUri().getPath());
            }
        };
        List<ExecDriver> mrtasks = Utilities.getMRTasks(rootTasks);
        boolean hasNonLocalJob = false;
        for (ExecDriver mrtask : mrtasks) {
            try {
                long estimatedInput;
                ContentSummary inputSummary = Utilities.getInputSummary(ctx, ((MapredWork)mrtask.getWork()).getMapWork(), p);
                int numReducers = MapReduceCompiler.getNumberOfReducers((MapredWork)mrtask.getWork(), this.conf);
                if (globalLimitCtx != null && globalLimitCtx.isEnable()) {
                    long sizePerRow = HiveConf.getLongVar(this.conf, HiveConf.ConfVars.HIVELIMITMAXROWSIZE);
                    estimatedInput = (long)globalLimitCtx.getGlobalLimit() * sizePerRow;
                    long minSplitSize = HiveConf.getLongVar(this.conf, HiveConf.ConfVars.MAPREDMINSPLITSIZE);
                    long estimatedNumMap = inputSummary.getLength() / minSplitSize + 1L;
                    estimatedInput *= estimatedNumMap + 1L;
                } else {
                    estimatedInput = inputSummary.getLength();
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Task: " + mrtask.getId() + ", Summary: " + inputSummary.getLength() + "," + inputSummary.getFileCount() + "," + numReducers + ", estimated Input: " + estimatedInput));
                }
                if (MapRedTask.isEligibleForLocalMode(this.conf, numReducers, estimatedInput, inputSummary.getFileCount()) != null) {
                    hasNonLocalJob = true;
                    break;
                }
                mrtask.setLocalMode(true);
            }
            catch (IOException e) {
                throw new SemanticException(e);
            }
        }
        if (!hasNonLocalJob) {
            ctx.setOriginalTracker(ShimLoader.getHadoopShims().getJobLauncherRpcAddress((Configuration)this.conf));
            ShimLoader.getHadoopShims().setJobLauncherRpcAddress((Configuration)this.conf, "local");
            this.console.printInfo("Automatically selecting local only mode for query");
        }
    }
}

