/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class OrcInputFormat
extends FileInputFormat<NullWritable, OrcStruct>
implements InputFormatChecker {
    private static final Log LOG = LogFactory.getLog(OrcInputFormat.class);

    public OrcInputFormat() {
        this.setMinSplitSize(16384L);
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId) {
        result[typeId] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcInputFormat.includeColumnRecursive(types, result, type.getSubtypes(i));
        }
    }

    private static boolean[] findIncludedColumns(List<OrcProto.Type> types, Configuration conf) {
        String includedStr = conf.get("hive.io.file.readcolumn.ids");
        if (includedStr == null || includedStr.trim().length() == 0) {
            return null;
        }
        int numColumns = types.size();
        boolean[] result = new boolean[numColumns];
        result[0] = true;
        OrcProto.Type root = types.get(0);
        ArrayList<Integer> included = ColumnProjectionUtils.getReadColumnIDs(conf);
        for (int i = 0; i < root.getSubtypesCount(); ++i) {
            if (!included.contains(i)) continue;
            OrcInputFormat.includeColumnRecursive(types, result, root.getSubtypes(i));
        }
        for (boolean include : result) {
            if (include) continue;
            return result;
        }
        return null;
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem((Configuration)conf);
        reporter.setStatus(fileSplit.toString());
        return new OrcRecordReader(OrcFile.createReader(fs, path), (Configuration)conf, fileSplit.getStart(), fileSplit.getLength());
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            try {
                OrcFile.createReader(fs, file.getPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private static class OrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private final int numColumns;
        private float progress = 0.0f;

        OrcRecordReader(Reader file, Configuration conf, long offset, long length) throws IOException {
            String serializedPushdown = conf.get("hive.io.filter.expr.serialized");
            String columnNamesString = conf.get("hive.io.file.readcolumn.names");
            String[] columnNames = null;
            SearchArgument sarg = null;
            List<OrcProto.Type> types = file.getTypes();
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            columnNames = new String[types.size()];
            LOG.info((Object)("included column ids = " + conf.get("hive.io.file.readcolumn.ids", "null")));
            LOG.info((Object)("included columns names = " + conf.get("hive.io.file.readcolumn.names", "null")));
            boolean[] includeColumn = OrcInputFormat.findIncludedColumns(types, conf);
            if (serializedPushdown != null && columnNamesString != null) {
                sarg = SearchArgument.FACTORY.create(Utilities.deserializeExpression(serializedPushdown, conf));
                LOG.info((Object)("ORC pushdown predicate: " + sarg));
                String[] neededColumnNames = columnNamesString.split(",");
                int i = 0;
                for (int columnId : types.get(0).getSubtypesList()) {
                    if (includeColumn != null && !includeColumn[columnId]) continue;
                    columnNames[columnId] = neededColumnNames[i++];
                }
            } else {
                LOG.info((Object)"No ORC pushdown predicate");
            }
            this.reader = file.rows(offset, length, includeColumn, sarg, columnNames);
            this.offset = offset;
            this.length = length;
        }

        public boolean next(NullWritable key, OrcStruct value) throws IOException {
            if (this.reader.hasNext()) {
                this.reader.next(value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return new OrcStruct(this.numColumns);
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }
    }
}

