/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.MinMaxPriorityQueue;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.hive.ql.exec.TopNHash;

class HashForRow
extends TopNHash {
    private final MinMaxPriorityQueue<Integer> indexes;

    HashForRow(int topN, long threshold, TopNHash.BinaryCollector collector) {
        super(topN, threshold, collector);
        this.indexes = MinMaxPriorityQueue.orderedBy((Comparator)this.C).create();
    }

    @Override
    protected int size() {
        return this.indexes.size();
    }

    @Override
    protected boolean store(int index) {
        return this.indexes.add((Object)index);
    }

    @Override
    protected int removeBiggest() {
        return (Integer)this.indexes.removeLast();
    }

    @Override
    protected Iterable<Integer> indexes() {
        Integer[] array = (Integer[])this.indexes.toArray((Object[])new Integer[this.indexes.size()]);
        Arrays.sort(array, 0, array.length, this.C);
        return Arrays.asList(array);
    }
}

