/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.kafka.connect.apiclient.Configuration;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.Request;
import org.sourcelab.kafka.connect.apiclient.rest.DefaultHttpClientConfigHooks;
import org.sourcelab.kafka.connect.apiclient.rest.HttpClientConfigHooks;
import org.sourcelab.kafka.connect.apiclient.rest.HttpsContextBuilder;
import org.sourcelab.kafka.connect.apiclient.rest.RestClient;
import org.sourcelab.kafka.connect.apiclient.rest.RestException;
import org.sourcelab.kafka.connect.apiclient.rest.RestResponse;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ConnectionException;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ResultParsingException;
import org.sourcelab.kafka.connect.apiclient.rest.handlers.RestResponseHandler;

public class HttpClientRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientRestClient.class);
    private static final Collection<Header> DEFAULT_HEADERS = Collections.unmodifiableCollection(Arrays.asList(new BasicHeader("Accept", "application/json"), new BasicHeader("Content-Type", "application/json")));
    private Configuration configuration;
    private CloseableHttpClient httpClient;
    private AuthCache authCache;
    private CredentialsProvider credsProvider;
    private final HttpClientConfigHooks configHooks;

    public HttpClientRestClient() {
        this(new DefaultHttpClientConfigHooks());
    }

    public HttpClientRestClient(HttpClientConfigHooks configHooks) {
        this.configHooks = configHooks;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        HttpsContextBuilder httpsContextBuilder = this.configHooks.createHttpsContextBuilder(configuration);
        HttpClientBuilder clientBuilder = Objects.requireNonNull(this.configHooks.createHttpClientBuilder(configuration), "HttpClientConfigHook::createHttpClientBuilder() must return non-null instance.");
        clientBuilder.setConnectionTimeToLive((long)configuration.getConnectionTimeToLiveInSeconds(), TimeUnit.SECONDS).setSSLSocketFactory(httpsContextBuilder.createSslSocketFactory());
        RequestConfig.Builder requestConfigBuilder = Objects.requireNonNull(this.configHooks.createRequestConfigBuilder(configuration), "HttpClientConfigHook::createRequestConfigBuilder() must return non-null instance.");
        requestConfigBuilder.setConnectTimeout(configuration.getRequestTimeoutInSeconds() * 1000);
        this.credsProvider = Objects.requireNonNull(this.configHooks.createCredentialsProvider(configuration), "HttpClientConfigHook::createCredentialsProvider() must return non-null instance.");
        this.authCache = Objects.requireNonNull(this.configHooks.createAuthCache(configuration), "HttpClientConfigHook::createAuthCache() must return non-null instance.");
        if (configuration.getProxyHost() != null) {
            HttpHost proxyHost = new HttpHost(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyScheme());
            if (configuration.getProxyUsername() != null) {
                this.credsProvider.setCredentials(new AuthScope(configuration.getProxyHost(), configuration.getProxyPort()), (Credentials)new UsernamePasswordCredentials(configuration.getProxyUsername(), configuration.getProxyPassword()));
                this.authCache.put(new HttpHost(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyScheme()), (AuthScheme)new BasicScheme());
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        if (configuration.getBasicAuthUsername() != null) {
            try {
                URL apiUrl = new URL(configuration.getApiHost());
                this.credsProvider.setCredentials(new AuthScope(apiUrl.getHost(), apiUrl.getPort()), (Credentials)new UsernamePasswordCredentials(configuration.getBasicAuthUsername(), configuration.getBasicAuthPassword()));
                this.authCache.put(new HttpHost(apiUrl.getHost(), apiUrl.getPort(), apiUrl.getProtocol()), (AuthScheme)new BasicScheme());
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        this.authCache = Objects.requireNonNull(this.configHooks.modifyAuthCache(configuration, this.authCache), "HttpClientConfigHook::modifyAuthCache() must return non-null instance.");
        this.credsProvider = Objects.requireNonNull(this.configHooks.modifyCredentialsProvider(configuration, this.credsProvider), "HttpClientConfigHook::modifyCredentialsProvider() must return non-null instance.");
        requestConfigBuilder = Objects.requireNonNull(this.configHooks.modifyRequestConfig(configuration, requestConfigBuilder), "HttpClientConfigHook::modifyRequestConfig() must return non-null instance.");
        clientBuilder.setDefaultCredentialsProvider(this.credsProvider);
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        clientBuilder = Objects.requireNonNull(this.configHooks.modifyHttpClientBuilder(configuration, clientBuilder), "HttpClientConfigHook::modifyHttpClientBuilder() must return non-null instance.");
        this.httpClient = clientBuilder.build();
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error closing: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.httpClient = null;
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    @Override
    public RestResponse submitRequest(Request request) throws RestException {
        String url = this.constructApiUrl(request.getApiEndpoint());
        RestResponseHandler responseHandler = new RestResponseHandler();
        try {
            switch (request.getRequestMethod()) {
                case GET: {
                    return this.submitGetRequest(url, Collections.emptyMap(), responseHandler);
                }
                case POST: {
                    return this.submitPostRequest(url, request.getRequestBody(), responseHandler);
                }
                case PUT: {
                    return this.submitPutRequest(url, request.getRequestBody(), responseHandler);
                }
                case DELETE: {
                    return this.submitDeleteRequest(url, request.getRequestBody(), responseHandler);
                }
            }
            throw new IllegalArgumentException("Unknown Request Method: " + (Object)((Object)request.getRequestMethod()));
        }
        catch (IOException exception) {
            throw new RestException(exception.getMessage(), exception);
        }
    }

    private <T> T submitGetRequest(String url, Map<String, String> getParams, ResponseHandler<T> responseHandler) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(url).setCharset(StandardCharsets.UTF_8);
            for (Map.Entry<String, String> entry : getParams.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
            HttpGet get = new HttpGet(uriBuilder.build());
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpGet)get).addHeader(arg_0));
            logger.debug("Executing request {}", (Object)get.getRequestLine());
            return this.execute((HttpUriRequest)get, responseHandler);
        }
        catch (SocketException | URISyntaxException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPostRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPost post = new HttpPost(url);
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpPost)post).addHeader(arg_0));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            post.setEntity((HttpEntity)new StringEntity(jsonPayloadStr));
            logger.debug("Executing request {} with {}", (Object)post.getRequestLine(), (Object)jsonPayloadStr);
            return this.execute((HttpUriRequest)post, responseHandler);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPutRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPut put = new HttpPut(url);
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpPut)put).addHeader(arg_0));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            put.setEntity((HttpEntity)new StringEntity(jsonPayloadStr));
            logger.debug("Executing request {} with {}", (Object)put.getRequestLine(), (Object)jsonPayloadStr);
            return this.execute((HttpUriRequest)put, responseHandler);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitDeleteRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpDelete delete = new HttpDelete(url);
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpDelete)delete).addHeader(arg_0));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            logger.debug("Executing request {} with {}", (Object)delete.getRequestLine(), (Object)jsonPayloadStr);
            return this.execute((HttpUriRequest)delete, responseHandler);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T execute(HttpUriRequest request, ResponseHandler<T> responseHandler) throws IOException {
        return (T)this.httpClient.execute(request, responseHandler, (HttpContext)this.createHttpClientContext());
    }

    private String constructApiUrl(String endPoint) {
        return this.configuration.getApiHost() + endPoint;
    }

    private HttpClientContext createHttpClientContext() {
        HttpClientContext httpClientContext = this.configHooks.createHttpClientContext(this.configuration);
        httpClientContext.setAuthCache(this.authCache);
        httpClientContext.setCredentialsProvider(this.credsProvider);
        return this.configHooks.modifyHttpClientContext(this.configuration, httpClientContext);
    }
}

