/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.put;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorPluginConfigValidationResults;
import org.sourcelab.kafka.connect.apiclient.request.put.PutRequest;
import org.sourcelab.kafka.connect.apiclient.util.UrlEscapingUtil;

public final class PutConnectorPluginConfigValidate
implements PutRequest<ConnectorPluginConfigValidationResults> {
    private final String connectorPluginName;
    private final Map<String, String> config;

    public PutConnectorPluginConfigValidate(String connectorPluginName, Map<String, String> config) {
        Objects.requireNonNull(connectorPluginName);
        Objects.requireNonNull(config);
        this.connectorPluginName = connectorPluginName;
        this.config = Collections.unmodifiableMap(new HashMap<String, String>(config));
    }

    @Override
    public String getApiEndpoint() {
        return "/connector-plugins/" + UrlEscapingUtil.escapePath(this.connectorPluginName) + "/config/validate";
    }

    @Override
    public Object getRequestBody() {
        return this.config;
    }

    @Override
    public ConnectorPluginConfigValidationResults parseResponse(String responseStr) throws IOException {
        return (ConnectorPluginConfigValidationResults)JacksonFactory.newInstance().readValue(responseStr, ConnectorPluginConfigValidationResults.class);
    }
}

