/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.dto;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorDefinition;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorStatus;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorsWithExpandedInfo;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorsWithExpandedStatus;

public class ConnectorsWithExpandedMetadata
implements ConnectorsWithExpandedInfo,
ConnectorsWithExpandedStatus {
    @JsonAnySetter
    private Map<String, ConnectorWithExpandedMetadata> results = new HashMap<String, ConnectorWithExpandedMetadata>();

    public ConnectorsWithExpandedMetadata() {
    }

    public ConnectorsWithExpandedMetadata(Map<String, ConnectorWithExpandedMetadata> results) {
        this.results = new HashMap<String, ConnectorWithExpandedMetadata>(results);
    }

    @Override
    public Collection<String> getConnectorNames() {
        return this.results.keySet();
    }

    @Override
    public ConnectorDefinition getDefinitionForConnector(String connectorName) {
        if (!this.results.containsKey(connectorName)) {
            throw new IllegalArgumentException("Results do not contain connector: " + connectorName);
        }
        return this.results.get(connectorName).getInfo();
    }

    @Override
    public Collection<ConnectorDefinition> getAllDefinitions() {
        return this.results.values().stream().map(ConnectorWithExpandedMetadata::getInfo).collect(Collectors.toList());
    }

    @Override
    public Map<String, ConnectorDefinition> getMappedDefinitions() {
        return Collections.unmodifiableMap(this.results.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConnectorWithExpandedMetadata)entry.getValue()).getInfo())));
    }

    @Override
    public ConnectorStatus getStatusForConnector(String connectorName) {
        if (!this.results.containsKey(connectorName)) {
            throw new IllegalArgumentException("Results do not contain connector: " + connectorName);
        }
        return this.results.get(connectorName).getStatus();
    }

    @Override
    public Collection<ConnectorStatus> getAllStatuses() {
        return this.results.values().stream().map(ConnectorWithExpandedMetadata::getStatus).collect(Collectors.toList());
    }

    @Override
    public Map<String, ConnectorStatus> getMappedStatuses() {
        return Collections.unmodifiableMap(this.results.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConnectorWithExpandedMetadata)entry.getValue()).getStatus())));
    }

    public String toString() {
        return "ConnectorsWithExpandedMetadata{" + this.results + '}';
    }

    public static class ConnectorWithExpandedMetadata {
        @JsonProperty(value="info")
        private ConnectorDefinition info;
        @JsonProperty(value="status")
        private ConnectorStatus status;

        public ConnectorWithExpandedMetadata() {
        }

        public ConnectorWithExpandedMetadata(ConnectorDefinition info, ConnectorStatus status) {
            this.info = info;
            this.status = status;
        }

        public ConnectorStatus getStatus() {
            return this.status;
        }

        public ConnectorDefinition getInfo() {
            return this.info;
        }

        public String toString() {
            String value = "ConnectorMetadata{";
            if (this.info != null) {
                value = value + "info=" + this.info;
                if (this.status != null) {
                    value = value + ", ";
                }
            }
            if (this.status != null) {
                value = value + "status=" + this.status;
            }
            value = value + '}';
            return value;
        }
    }
}

