/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.kafka.connect.apiclient.Configuration;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.Request;
import org.sourcelab.kafka.connect.apiclient.rest.HttpsContextBuilder;
import org.sourcelab.kafka.connect.apiclient.rest.RestClient;
import org.sourcelab.kafka.connect.apiclient.rest.RestException;
import org.sourcelab.kafka.connect.apiclient.rest.RestResponse;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ConnectionException;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ResultParsingException;
import org.sourcelab.kafka.connect.apiclient.rest.handlers.RestResponseHandler;

public class HttpClientRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientRestClient.class);
    private static final Collection<Header> DEFAULT_HEADERS = Collections.unmodifiableCollection(Arrays.asList(new BasicHeader("Accept", "application/json"), new BasicHeader("Content-Type", "application/json")));
    private Configuration configuration;
    private CloseableHttpClient httpClient;
    private HttpClientContext httpClientContext;

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        HttpsContextBuilder httpsContextBuilder = new HttpsContextBuilder(configuration);
        HttpClientBuilder clientBuilder = this.createHttpClientBuilder();
        clientBuilder.setConnectionTimeToLive((long)configuration.getConnectionTimeToLiveInSeconds(), TimeUnit.SECONDS).setSSLSocketFactory(httpsContextBuilder.createSslSocketFactory());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(configuration.getRequestTimeoutInSeconds() * 1000);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        this.httpClientContext = HttpClientContext.create();
        BasicAuthCache authCache = new BasicAuthCache();
        if (configuration.getProxyHost() != null) {
            HttpHost proxyHost = new HttpHost(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyScheme());
            if (configuration.getProxyUsername() != null) {
                credsProvider.setCredentials(new AuthScope(configuration.getProxyHost(), configuration.getProxyPort()), (Credentials)new UsernamePasswordCredentials(configuration.getProxyUsername(), configuration.getProxyPassword()));
                authCache.put(new HttpHost(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyScheme()), (AuthScheme)new BasicScheme());
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        if (configuration.getBasicAuthUsername() != null) {
            try {
                URL apiUrl = new URL(configuration.getApiHost());
                credsProvider.setCredentials(new AuthScope(apiUrl.getHost(), apiUrl.getPort()), (Credentials)new UsernamePasswordCredentials(configuration.getBasicAuthUsername(), configuration.getBasicAuthPassword()));
                authCache.put(new HttpHost(apiUrl.getHost(), apiUrl.getPort(), apiUrl.getProtocol()), (AuthScheme)new BasicScheme());
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        this.httpClientContext.setAuthCache((AuthCache)authCache);
        this.httpClientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.httpClient = clientBuilder.build();
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error closing: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.httpClient = null;
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    @Override
    public RestResponse submitRequest(Request request) throws RestException {
        String url = this.constructApiUrl(request.getApiEndpoint());
        RestResponseHandler responseHandler = new RestResponseHandler();
        try {
            switch (request.getRequestMethod()) {
                case GET: {
                    return this.submitGetRequest(url, Collections.emptyMap(), responseHandler);
                }
                case POST: {
                    return this.submitPostRequest(url, request.getRequestBody(), responseHandler);
                }
                case PUT: {
                    return this.submitPutRequest(url, request.getRequestBody(), responseHandler);
                }
                case DELETE: {
                    return this.submitDeleteRequest(url, request.getRequestBody(), responseHandler);
                }
            }
            throw new IllegalArgumentException("Unknown Request Method: " + (Object)((Object)request.getRequestMethod()));
        }
        catch (IOException exception) {
            throw new RestException(exception.getMessage(), exception);
        }
    }

    private <T> T submitGetRequest(String url, Map<String, String> getParams, ResponseHandler<T> responseHandler) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(url).setCharset(StandardCharsets.UTF_8);
            for (Map.Entry<String, String> entry : getParams.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
            HttpGet get = new HttpGet(uriBuilder.build());
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpGet)get).addHeader(arg_0));
            logger.debug("Executing request {}", (Object)get.getRequestLine());
            return (T)this.httpClient.execute((HttpUriRequest)get, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | URISyntaxException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPostRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPost post = new HttpPost(url);
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpPost)post).addHeader(arg_0));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            post.setEntity((HttpEntity)new StringEntity(jsonPayloadStr));
            logger.debug("Executing request {} with {}", (Object)post.getRequestLine(), (Object)jsonPayloadStr);
            return (T)this.httpClient.execute((HttpUriRequest)post, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPutRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPut put = new HttpPut(url);
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpPut)put).addHeader(arg_0));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            put.setEntity((HttpEntity)new StringEntity(jsonPayloadStr));
            logger.debug("Executing request {} with {}", (Object)put.getRequestLine(), (Object)jsonPayloadStr);
            return (T)this.httpClient.execute((HttpUriRequest)put, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitDeleteRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpDelete delete = new HttpDelete(url);
            DEFAULT_HEADERS.forEach(arg_0 -> ((HttpDelete)delete).addHeader(arg_0));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            logger.debug("Executing request {} with {}", (Object)delete.getRequestLine(), (Object)jsonPayloadStr);
            return (T)this.httpClient.execute((HttpUriRequest)delete, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private String constructApiUrl(String endPoint) {
        return this.configuration.getApiHost() + endPoint;
    }
}

