/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.rest.exceptions;

import com.google.common.base.Preconditions;
import org.sourcelab.kafka.connect.apiclient.request.RequestErrorResponse;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ConcurrentConfigModificationException;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ResourceNotFoundException;

public class InvalidRequestException
extends RuntimeException {
    private final int errorCode;

    public InvalidRequestException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public InvalidRequestException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = -1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public static InvalidRequestException factory(RequestErrorResponse errorResponse) {
        Preconditions.checkNotNull((Object)errorResponse, (Object)"Invalid RequestErrorResponse parameter, must not be null");
        switch (errorResponse.getErrorCode()) {
            case 404: {
                return new ResourceNotFoundException(errorResponse.getMessage());
            }
            case 409: {
                return new ConcurrentConfigModificationException(errorResponse.getMessage());
            }
        }
        return new InvalidRequestException(errorResponse.getMessage(), errorResponse.getErrorCode());
    }
}

