/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.put;

import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorPluginConfigValidationResults;
import org.sourcelab.kafka.connect.apiclient.request.put.PutRequest;

public final class PutConnectorPluginConfigValidate
implements PutRequest<ConnectorPluginConfigValidationResults> {
    private final String connectorPluginName;
    private final Map<String, String> config;

    public PutConnectorPluginConfigValidate(String connectorPluginName, Map<String, String> config) {
        Preconditions.checkNotNull((Object)connectorPluginName);
        Preconditions.checkNotNull(config);
        this.connectorPluginName = connectorPluginName;
        this.config = Collections.unmodifiableMap(new HashMap<String, String>(config));
    }

    @Override
    public String getApiEndpoint() {
        return "/connector-plugins/" + UrlEscapers.urlPathSegmentEscaper().escape(this.connectorPluginName) + "/config/validate";
    }

    @Override
    public Object getRequestBody() {
        return this.config;
    }

    @Override
    public ConnectorPluginConfigValidationResults parseResponse(String responseStr) throws IOException {
        return (ConnectorPluginConfigValidationResults)JacksonFactory.newInstance().readValue(responseStr, ConnectorPluginConfigValidationResults.class);
    }
}

