/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.get;

import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorStatus;
import org.sourcelab.kafka.connect.apiclient.request.get.GetRequest;

public final class GetConnectorStatus
implements GetRequest<ConnectorStatus> {
    private final String connectorName;

    public GetConnectorStatus(String connectorName) {
        Preconditions.checkNotNull((Object)connectorName);
        this.connectorName = connectorName;
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapers.urlPathSegmentEscaper().escape(this.connectorName) + "/status";
    }

    @Override
    public Object getRequestBody() {
        return null;
    }

    @Override
    public ConnectorStatus parseResponse(String responseStr) throws IOException {
        return (ConnectorStatus)JacksonFactory.newInstance().readValue(responseStr, ConnectorStatus.class);
    }
}

