/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.get;

import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Map;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.get.GetRequest;

public final class GetConnectorConfig
implements GetRequest<Map<String, String>> {
    private final String connectorName;

    public GetConnectorConfig(String connectorName) {
        Preconditions.checkNotNull((Object)connectorName);
        this.connectorName = connectorName;
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapers.urlPathSegmentEscaper().escape(this.connectorName) + "/config";
    }

    @Override
    public Object getRequestBody() {
        return null;
    }

    @Override
    public Map<String, String> parseResponse(String responseStr) throws IOException {
        return (Map)JacksonFactory.newInstance().readValue(responseStr, Map.class);
    }
}

