/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient;

public final class Configuration {
    private final String apiHost;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyScheme = "HTTP";
    private String proxyUsername = null;
    private String proxyPassword = null;

    public Configuration(String kafkaConnectHost) {
        if (kafkaConnectHost == null) {
            throw new NullPointerException("Kafka Connect Host parameter cannot be null!");
        }
        this.apiHost = !kafkaConnectHost.startsWith("http://") ? "http://" + kafkaConnectHost : kafkaConnectHost;
    }

    public Configuration useProxy(String proxyHost, int proxyPort, String proxyScheme) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyScheme = proxyScheme;
        return this;
    }

    public Configuration useProxyAuthentication(String proxyUsername, String proxyPassword) {
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration{").append("apiHost='").append(this.apiHost).append('\'');
        if (this.proxyHost != null) {
            stringBuilder.append(", proxy='").append(this.proxyScheme).append("://");
            if (this.proxyUsername != null) {
                stringBuilder.append(this.proxyUsername).append(':').append("XXXXXXX@");
            }
            stringBuilder.append(this.proxyHost).append(":").append(this.proxyPort).append('\'');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

