/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.rest;

import java.io.IOException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.kafka.connect.apiclient.Configuration;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.Request;
import org.sourcelab.kafka.connect.apiclient.rest.RestClient;
import org.sourcelab.kafka.connect.apiclient.rest.RestException;
import org.sourcelab.kafka.connect.apiclient.rest.RestResponse;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ConnectionException;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.ResultParsingException;
import org.sourcelab.kafka.connect.apiclient.rest.handlers.RestResponseHandler;

public class HttpClientRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientRestClient.class);
    private Configuration configuration;
    private CloseableHttpClient httpClient;

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        SSLContext sslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setConnectionTimeToLive(300L, TimeUnit.SECONDS).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (configuration.getProxyHost() != null) {
            HttpHost proxyHost = new HttpHost(configuration.getProxyHost(), configuration.getProxyPort(), configuration.getProxyScheme());
            if (configuration.getProxyUsername() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(configuration.getProxyHost(), configuration.getProxyPort()), (Credentials)new UsernamePasswordCredentials(configuration.getProxyUsername(), configuration.getProxyPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.httpClient = clientBuilder.build();
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error closing: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.httpClient = null;
    }

    @Override
    public RestResponse submitRequest(Request request) throws RestException {
        String url = this.constructApiUrl(request.getApiEndpoint());
        RestResponseHandler responseHandler = new RestResponseHandler();
        try {
            switch (request.getRequestMethod()) {
                case GET: {
                    return this.submitGetRequest(url, Collections.emptyMap(), responseHandler);
                }
                case POST: {
                    return this.submitPostRequest(url, request.getRequestBody(), responseHandler);
                }
                case PUT: {
                    return this.submitPutRequest(url, request.getRequestBody(), responseHandler);
                }
                case DELETE: {
                    return this.submitDeleteRequest(url, request.getRequestBody(), responseHandler);
                }
            }
            throw new IllegalArgumentException("Unknown Request Method: " + (Object)((Object)request.getRequestMethod()));
        }
        catch (IOException exception) {
            throw new RestException(exception.getMessage(), exception);
        }
    }

    private <T> T submitGetRequest(String url, Map<String, String> getParams, ResponseHandler<T> responseHandler) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(url).setCharset(StandardCharsets.UTF_8);
            for (Map.Entry<String, String> entry : getParams.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
            HttpGet get = new HttpGet(uriBuilder.build());
            get.addHeader((Header)new BasicHeader("Accept", "application/json"));
            get.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
            logger.debug("Executing request {}", (Object)get.getRequestLine());
            return (T)this.httpClient.execute((HttpUriRequest)get, responseHandler);
        }
        catch (SocketException | URISyntaxException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPostRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpPost post = new HttpPost(url);
            post.addHeader((Header)new BasicHeader("Accept", "application/json"));
            post.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
            ArrayList params = new ArrayList();
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            post.setEntity((HttpEntity)new StringEntity(jsonPayloadStr));
            logger.debug("Executing request {} with {}", (Object)post.getRequestLine(), (Object)jsonPayloadStr);
            return (T)this.httpClient.execute((HttpUriRequest)post, responseHandler);
        }
        catch (SocketException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPutRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(url).setCharset(StandardCharsets.UTF_8);
            HttpPut put = new HttpPut(url);
            put.addHeader((Header)new BasicHeader("Accept", "application/json"));
            put.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            put.setEntity((HttpEntity)new StringEntity(jsonPayloadStr));
            logger.debug("Executing request {} with {}", (Object)put.getRequestLine(), (Object)jsonPayloadStr);
            return (T)this.httpClient.execute((HttpUriRequest)put, responseHandler);
        }
        catch (SocketException | URISyntaxException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitDeleteRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(url).setCharset(StandardCharsets.UTF_8);
            HttpDelete delete = new HttpDelete(url);
            delete.addHeader((Header)new BasicHeader("Accept", "application/json"));
            delete.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
            ArrayList params = new ArrayList();
            String jsonPayloadStr = JacksonFactory.newInstance().writeValueAsString(requestBody);
            logger.debug("Executing request {} with {}", (Object)delete.getRequestLine(), (Object)jsonPayloadStr);
            return (T)this.httpClient.execute((HttpUriRequest)delete, responseHandler);
        }
        catch (SocketException | URISyntaxException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private String constructApiUrl(String endPoint) {
        return this.configuration.getApiHost() + endPoint;
    }
}

