/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.get;

import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorDefinition;
import org.sourcelab.kafka.connect.apiclient.request.get.GetRequest;

public final class GetConnector
implements GetRequest<ConnectorDefinition> {
    private final String connectorName;

    public GetConnector(String connectorName) {
        Preconditions.checkNotNull((Object)connectorName);
        this.connectorName = connectorName;
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapers.urlPathSegmentEscaper().escape(this.connectorName);
    }

    @Override
    public Object getRequestBody() {
        return null;
    }

    @Override
    public ConnectorDefinition parseResponse(String responseStr) throws IOException {
        return (ConnectorDefinition)JacksonFactory.newInstance().readValue(responseStr, ConnectorDefinition.class);
    }
}

