/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sourcegrade.jagr.api.rubric.GradedRubric;
import org.sourcegrade.jagr.launcher.env.Jagr;
import org.sourcegrade.jagr.launcher.env.JagrKt;
import org.sourcegrade.jagr.launcher.executor.GradingResult;
import org.sourcegrade.jagr.launcher.io.RubricLoggingKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"logGradedRubric", "", "Lorg/sourcegrade/jagr/api/rubric/GradedRubric;", "jagr", "Lorg/sourcegrade/jagr/launcher/env/Jagr;", "logHistogram", "", "Lorg/sourcegrade/jagr/launcher/executor/GradingResult;", "jagr-launcher"})
@SourceDebugExtension(value={"SMAP\nRubricLogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubricLogging.kt\norg/sourcegrade/jagr/launcher/io/RubricLoggingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1360#2:73\n1446#2,5:74\n1#3:79\n*S KotlinDebug\n*F\n+ 1 RubricLogging.kt\norg/sourcegrade/jagr/launcher/io/RubricLoggingKt\n*L\n31#1:73\n31#1:74,5\n*E\n"})
public final class RubricLoggingKt {
    /*
     * WARNING - void declaration
     */
    public static final void logHistogram(@NotNull List<GradingResult> $this$logHistogram, @NotNull Jagr jagr) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$logHistogram, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jagr, (String)"jagr");
        Map histogram = new LinkedHashMap();
        int minPoints = 0;
        int maxPoints = 0;
        Iterable $this$flatMap$iv = $this$logHistogram;
        boolean bl = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GradingResult it = (GradingResult)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getRubrics().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allRubrics = (List)destination$iv$iv;
        for (GradedRubric gradedRubric : allRubrics) {
            Integer n = histogram.computeIfAbsent(gradedRubric.getGrade().getMinPoints(), arg_0 -> RubricLoggingKt.logHistogram$lambda$1(logHistogram.prev.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"histogram.computeIfAbsen\u2026ic.grade.minPoints) { 0 }");
            int prev2 = ((Number)n).intValue();
            histogram.put(gradedRubric.getGrade().getMinPoints(), prev2 + 1);
            minPoints += gradedRubric.getGrade().getMinPoints();
            maxPoints += gradedRubric.getRubric().getMaxPoints();
        }
        if (allRubrics.isEmpty()) {
            return;
        }
        JagrKt.getLogger(jagr).info("Result: Min: " + minPoints + ", Max: " + maxPoints + ", Average: " + (double)minPoints / (double)allRubrics.size() + ", Rubrics: " + allRubrics.size());
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap((Map)histogram)).entrySet()) {
            StringBuilder stringBuilder;
            Integer points = (Integer)entry.getKey();
            Integer count = (Integer)entry.getValue();
            StringBuilder $this$logHistogram_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            $this$logHistogram_u24lambda_u242.append("Points: ");
            $this$logHistogram_u24lambda_u242.append(StringsKt.padStart$default((String)String.valueOf(points), (int)3, (char)'\u0000', (int)2, null));
            $this$logHistogram_u24lambda_u242.append(" Nr: ");
            $this$logHistogram_u24lambda_u242.append(StringsKt.padStart$default((String)String.valueOf(count), (int)3, (char)'\u0000', (int)2, null));
            $this$logHistogram_u24lambda_u242.append(" |");
            Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
            int n = count;
            for (int i = 0; i < n; ++i) {
                $this$logHistogram_u24lambda_u242.append('-');
            }
            StringBuilder it = stringBuilder;
            boolean bl2 = false;
            JagrKt.getLogger(jagr).info(it.toString());
        }
    }

    public static final void logGradedRubric(@NotNull GradedRubric $this$logGradedRubric, @NotNull Jagr jagr) {
        Intrinsics.checkNotNullParameter((Object)$this$logGradedRubric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jagr, (String)"jagr");
        int succeeded = $this$logGradedRubric.getTestCycle().getTestsSucceededCount();
        int total = $this$logGradedRubric.getTestCycle().getTestsStartedCount();
        String info = total == 0 ? " (no tests found)" : " (" + succeeded + "/" + total + " tests) minPoints=" + $this$logGradedRubric.getGrade().getMinPoints() + "/" + $this$logGradedRubric.getRubric().getMaxPoints() + " maxPoints=" + $this$logGradedRubric.getGrade().getMaxPoints() + "/" + $this$logGradedRubric.getRubric().getMaxPoints() + " from '" + $this$logGradedRubric.getRubric().getTitle() + "'";
        JagrKt.getLogger(jagr).info($this$logGradedRubric.getTestCycle().getSubmission() + " :: " + info);
    }

    private static final Integer logHistogram$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }
}

