/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.io;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sourcegrade.jagr.launcher.io.Resource;
import org.sourcegrade.jagr.launcher.io.ResourceContainer;
import org.sourcegrade.jagr.launcher.io.ResourceContainerBuilderImpl;
import org.sourcegrade.jagr.launcher.io.ResourceContainerInfo;
import org.sourcegrade.jagr.launcher.io.ResourceContainerInfoBuilderImpl;
import org.sourcegrade.jagr.launcher.io.ResourceKt;
import org.sourcegrade.jagr.launcher.io.ZipResourceContainer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0086\b\u00f8\u0001\u0000\u001a%\u0010\f\u001a\u00020\u00022\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0086\b\u00f8\u0001\u0000\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0006\u0010\u0014\u001a\u00020\t\u001a\u0006\u0010\u0015\u001a\u00020\r\u001a)\u0010\u0016\u001a\u00020\n*\u00020\t2\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u0018\u001a\u00020\u0006*\u00020\u0019\u001a\u0012\u0010\u001a\u001a\u00020\n*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"nameWithoutExtension", "", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainerInfo;", "getNameWithoutExtension", "(Lorg/sourcegrade/jagr/launcher/io/ResourceContainerInfo;)Ljava/lang/String;", "buildResourceContainer", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainer;", "configure", "Lkotlin/Function1;", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainer$Builder;", "", "Lkotlin/ExtensionFunctionType;", "buildResourceContainerInfo", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainerInfo$Builder;", "createResourceContainer", "file", "Ljava/io/File;", "name", "inputStream", "Ljava/io/InputStream;", "createResourceContainerBuilder", "createResourceContainerInfoBuilder", "addResource", "Lorg/sourcegrade/jagr/launcher/io/Resource$Builder;", "toContainer", "Lorg/sourcegrade/jagr/launcher/io/Resource;", "writeAsDirIn", "dir", "jagr-launcher"})
@SourceDebugExtension(value={"SMAP\nResourceContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceContainer.kt\norg/sourcegrade/jagr/launcher/io/ResourceContainerKt\n+ 2 Resource.kt\norg/sourcegrade/jagr/launcher/io/ResourceKt\n*L\n1#1,111:1\n38#2:112\n*S KotlinDebug\n*F\n+ 1 ResourceContainer.kt\norg/sourcegrade/jagr/launcher/io/ResourceContainerKt\n*L\n62#1:112\n*E\n"})
public final class ResourceContainerKt {
    @NotNull
    public static final String getNameWithoutExtension(@NotNull ResourceContainerInfo $this$nameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$nameWithoutExtension, (String)"<this>");
        return StringsKt.substringBeforeLast$default((String)$this$nameWithoutExtension.getName(), (String)".", null, (int)2, null);
    }

    @NotNull
    public static final ResourceContainer toContainer(@NotNull Resource $this$toContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$toContainer, (String)"<this>");
        return ResourceContainerKt.createResourceContainer($this$toContainer.getName(), $this$toContainer.getInputStream());
    }

    @NotNull
    public static final ResourceContainer buildResourceContainer(@NotNull Function1<? super ResourceContainer.Builder, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        boolean $i$f$buildResourceContainer = false;
        ResourceContainer.Builder builder = ResourceContainerKt.createResourceContainerBuilder();
        configure.invoke((Object)builder);
        return builder.build();
    }

    public static final void addResource(@NotNull ResourceContainer.Builder $this$addResource, @NotNull Function1<? super Resource.Builder, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)$this$addResource, (String)"<this>");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        boolean $i$f$addResource = false;
        boolean $i$f$buildResource = false;
        Resource.Builder builder = ResourceKt.createResourceBuilder();
        configure.invoke((Object)builder);
        $this$addResource.addResource(builder.build());
    }

    @NotNull
    public static final ResourceContainer.Builder createResourceContainerBuilder() {
        return new ResourceContainerBuilderImpl();
    }

    @NotNull
    public static final ResourceContainerInfo buildResourceContainerInfo(@NotNull Function1<? super ResourceContainerInfo.Builder, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        boolean $i$f$buildResourceContainerInfo = false;
        ResourceContainerInfo.Builder builder = ResourceContainerKt.createResourceContainerInfoBuilder();
        configure.invoke((Object)builder);
        return builder.build();
    }

    @NotNull
    public static final ResourceContainerInfo.Builder createResourceContainerInfoBuilder() {
        return new ResourceContainerInfoBuilderImpl();
    }

    @NotNull
    public static final ResourceContainer createResourceContainer(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return new ZipResourceContainer(name, inputStream);
    }

    @NotNull
    public static final ResourceContainer createResourceContainer(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FilesKt.getExtension((File)file);
        if (!(Intrinsics.areEqual((Object)string, (Object)"zip") ? true : Intrinsics.areEqual((Object)string, (Object)"jar"))) {
            throw new IllegalArgumentException("Could not an appropriate resource container for " + file);
        }
        return new ZipResourceContainer(file);
    }

    public static final void writeAsDirIn(@NotNull ResourceContainer $this$writeAsDirIn, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAsDirIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        File root = FilesKt.resolve((File)dir, (String)$this$writeAsDirIn.getInfo().getName());
        Iterator iterator = $this$writeAsDirIn.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            ResourceKt.writeIn$default(resource, root, null, 2, null);
        }
    }
}

