/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sourcegrade.jagr.launcher.io.GradingBatch;
import org.sourcegrade.jagr.launcher.io.GradingBatchImpl;
import org.sourcegrade.jagr.launcher.io.ResourceContainer;
import org.sourcegrade.jagr.launcher.io.ResourceContainerKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001a\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00192\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00192\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00192\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/sourcegrade/jagr/launcher/io/GradingBatchBuilder;", "", "()V", "graders", "", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainer;", "libraries", "submissions", "totalExpectedCount", "", "addGrader", "", "container", "addLibrary", "addSubmission", "build", "Lorg/sourcegrade/jagr/launcher/io/GradingBatch;", "discover", "", "dir", "Ljava/io/File;", "filter", "Ljava/io/FilenameFilter;", "list", "discoverGraders", "", "discoverLibraries", "discoverSubmissions", "jagr-launcher"})
@SourceDebugExtension(value={"SMAP\nGradingBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradingBatch.kt\norg/sourcegrade/jagr/launcher/io/GradingBatchBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class GradingBatchBuilder {
    @NotNull
    private final List<ResourceContainer> graders = new ArrayList();
    @NotNull
    private final List<ResourceContainer> submissions = new ArrayList();
    @NotNull
    private final List<ResourceContainer> libraries = new ArrayList();
    private int totalExpectedCount;

    private final void discover(File dir, FilenameFilter filter, List<ResourceContainer> list) {
        if (!(dir.exists() || dir.mkdirs())) {
            boolean bl = false;
            String string = "Unable to create directory " + dir;
            throw new IllegalStateException(string.toString());
        }
        File[] fileArray = dir.listFiles(filter);
        if (fileArray == null) {
            boolean bl = false;
            String string = "Could not find " + dir;
            throw new IllegalStateException(string.toString());
        }
        for (File candidate : fileArray) {
            Collection collection = list;
            Intrinsics.checkNotNullExpressionValue((Object)candidate, (String)"candidate");
            collection.add(ResourceContainerKt.createResourceContainer(candidate));
        }
    }

    public final void discoverGraders(@NotNull File dir, @Nullable FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.discover(dir, filter, this.graders);
    }

    public static /* synthetic */ void discoverGraders$default(GradingBatchBuilder gradingBatchBuilder, File file, FilenameFilter filenameFilter, int n, Object object) {
        if ((n & 2) != 0) {
            filenameFilter = null;
        }
        gradingBatchBuilder.discoverGraders(file, filenameFilter);
    }

    public final void discoverGraders(@NotNull String dir, @Nullable FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.discoverGraders(new File(dir), filter);
    }

    public static /* synthetic */ void discoverGraders$default(GradingBatchBuilder gradingBatchBuilder, String string, FilenameFilter filenameFilter, int n, Object object) {
        if ((n & 2) != 0) {
            filenameFilter = null;
        }
        gradingBatchBuilder.discoverGraders(string, filenameFilter);
    }

    public final void discoverSubmissions(@NotNull File dir, @Nullable FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!(dir.exists() || dir.mkdirs())) {
            boolean bl = false;
            String string = "Unable to create directory " + dir;
            throw new IllegalStateException(string.toString());
        }
        File[] fileArray = dir.listFiles(filter);
        if (fileArray == null) {
            boolean bl = false;
            String string = "Could not find " + dir;
            throw new IllegalStateException(string.toString());
        }
        for (File candidate : fileArray) {
            Collection collection = this.submissions;
            Intrinsics.checkNotNullExpressionValue((Object)candidate, (String)"candidate");
            collection.add(ResourceContainerKt.createResourceContainer(candidate));
            ++this.totalExpectedCount;
        }
    }

    public static /* synthetic */ void discoverSubmissions$default(GradingBatchBuilder gradingBatchBuilder, File file, FilenameFilter filenameFilter, int n, Object object) {
        if ((n & 2) != 0) {
            filenameFilter = null;
        }
        gradingBatchBuilder.discoverSubmissions(file, filenameFilter);
    }

    public final void discoverSubmissions(@NotNull String dir, @Nullable FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.discoverSubmissions(new File(dir), filter);
    }

    public static /* synthetic */ void discoverSubmissions$default(GradingBatchBuilder gradingBatchBuilder, String string, FilenameFilter filenameFilter, int n, Object object) {
        if ((n & 2) != 0) {
            filenameFilter = null;
        }
        gradingBatchBuilder.discoverSubmissions(string, filenameFilter);
    }

    public final void discoverLibraries(@NotNull File dir, @Nullable FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.discover(dir, filter, this.libraries);
    }

    public static /* synthetic */ void discoverLibraries$default(GradingBatchBuilder gradingBatchBuilder, File file, FilenameFilter filenameFilter, int n, Object object) {
        if ((n & 2) != 0) {
            filenameFilter = null;
        }
        gradingBatchBuilder.discoverLibraries(file, filenameFilter);
    }

    public final void discoverLibraries(@NotNull String dir, @Nullable FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.discoverLibraries(new File(dir), filter);
    }

    public static /* synthetic */ void discoverLibraries$default(GradingBatchBuilder gradingBatchBuilder, String string, FilenameFilter filenameFilter, int n, Object object) {
        if ((n & 2) != 0) {
            filenameFilter = null;
        }
        gradingBatchBuilder.discoverLibraries(string, filenameFilter);
    }

    public final boolean addGrader(@NotNull ResourceContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return this.graders.add(container);
    }

    public final boolean addSubmission(@NotNull ResourceContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        ++this.totalExpectedCount;
        return this.submissions.add(container);
    }

    public final boolean addLibrary(@NotNull ResourceContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return this.libraries.add(container);
    }

    @NotNull
    public final GradingBatch build() {
        return new GradingBatchImpl(this.graders, this.submissions, this.libraries, this.totalExpectedCount);
    }
}

