/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.executor;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sourcegrade.jagr.launcher.executor.ProgressBar;
import org.sourcegrade.jagr.launcher.executor.ProgressBarKt;
import org.sourcegrade.jagr.launcher.executor.ProgressBarProvider;
import org.sourcegrade.jagr.launcher.executor.ProgressBarProviderKt;
import org.sourcegrade.jagr.launcher.executor.RubricCollector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0019\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lorg/sourcegrade/jagr/launcher/executor/ProgressBar;", "", "rubricCollector", "Lorg/sourcegrade/jagr/launcher/executor/RubricCollector;", "progressBarProvider", "Lorg/sourcegrade/jagr/launcher/executor/ProgressBarProvider;", "showElementsIfLessThan", "", "(Lorg/sourcegrade/jagr/launcher/executor/RubricCollector;Lorg/sourcegrade/jagr/launcher/executor/ProgressBarProvider;I)V", "bufferPos", "bufferSize", "decimalFormat", "Ljava/text/DecimalFormat;", "deltaBuffer", "", "gradingStart", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "lastFinished", "timeBuffer", "", "[Ljava/time/Instant;", "calculateVelocity", "Ljava/time/Duration;", "clear", "", "out", "Ljava/io/PrintStream;", "print", "(Ljava/io/PrintStream;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jagr-launcher"})
@SourceDebugExtension(value={"SMAP\nProgressBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressBar.kt\norg/sourcegrade/jagr/launcher/executor/ProgressBar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1789#2,3:112\n*S KotlinDebug\n*F\n+ 1 ProgressBar.kt\norg/sourcegrade/jagr/launcher/executor/ProgressBar\n*L\n60#1:112,3\n*E\n"})
public final class ProgressBar {
    @NotNull
    private final RubricCollector rubricCollector;
    @NotNull
    private final ProgressBarProvider progressBarProvider;
    private final int showElementsIfLessThan;
    @NotNull
    private final DecimalFormat decimalFormat;
    private final Instant gradingStart;
    private final int bufferSize;
    @NotNull
    private final int[] deltaBuffer;
    @NotNull
    private final Instant[] timeBuffer;
    private int bufferPos;
    private int lastFinished;

    public ProgressBar(@NotNull RubricCollector rubricCollector, @NotNull ProgressBarProvider progressBarProvider, int showElementsIfLessThan) {
        Intrinsics.checkNotNullParameter((Object)rubricCollector, (String)"rubricCollector");
        Intrinsics.checkNotNullParameter((Object)progressBarProvider, (String)"progressBarProvider");
        this.rubricCollector = rubricCollector;
        this.progressBarProvider = progressBarProvider;
        this.showElementsIfLessThan = showElementsIfLessThan;
        this.decimalFormat = new DecimalFormat("00.00");
        this.gradingStart = Instant.now();
        this.bufferSize = 32;
        this.deltaBuffer = new int[this.bufferSize];
        this.timeBuffer = new Instant[this.bufferSize];
    }

    public /* synthetic */ ProgressBar(RubricCollector rubricCollector, ProgressBarProvider progressBarProvider, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 3;
        }
        this(rubricCollector, progressBarProvider, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Duration calculateVelocity() {
        Duration duration;
        List all = new ArrayList();
        int n = this.bufferSize;
        for (int i = 1; i < n; ++i) {
            Instant end;
            Instant start2;
            int posA = (this.bufferPos + i - 1 + this.bufferSize) % this.bufferSize;
            int posB = (this.bufferPos + i + this.bufferSize) % this.bufferSize;
            if (this.timeBuffer[posA] == null || this.timeBuffer[posB] == null) continue;
            int it = this.deltaBuffer[posA];
            boolean bl = false;
            if (it == 0) continue;
            ((Collection)all).add(Duration.between(start2, end).multipliedBy(it));
        }
        if (all.isEmpty()) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"{\n            Duration.ZERO\n        }");
        } else {
            void $this$fold$iv;
            Iterable iterable = all;
            Duration initial$iv = Duration.ZERO;
            boolean $i$f$fold = false;
            Duration accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p1;
                Duration it = (Duration)element$iv;
                Duration p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.plus((Duration)p1);
            }
            Duration duration3 = accumulator$iv.dividedBy(all.size());
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"{\n            all.fold(D\u2026.size.toLong())\n        }");
        }
        return duration;
    }

    @Nullable
    public final Object print(@NotNull PrintStream out, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.rubricCollector.withSnapshot((Function2)new Function2<RubricCollector.Snapshot, Continuation<? super Unit>, Object>(this, out, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ProgressBar this$0;
            final /* synthetic */ PrintStream $out;
            {
                this.this$0 = $receiver;
                this.$out = $out;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        int i;
                        ResultKt.throwOnFailure((Object)object);
                        RubricCollector.Snapshot snapshot = (RubricCollector.Snapshot)this.L$0;
                        int finished = snapshot.getGradingFinished().size();
                        int total = snapshot.getTotal();
                        double progressDecimal = (double)finished / RangesKt.coerceAtLeast((double)total, (double)0.0);
                        String formattedPercentage = ProgressBar.access$getDecimalFormat$p(this.this$0).format(progressDecimal * 100.0);
                        int barCount = (int)((double)50 * progressDecimal);
                        StringBuilder sb = new StringBuilder(30);
                        sb.append("\u001b[38;5;250m");
                        sb.append('[');
                        sb.append(ProgressBarProviderKt.createProgressBar(ProgressBar.access$getProgressBarProvider$p(this.this$0), progressDecimal));
                        for (i = barCount; i < 50; ++i) {
                            sb.append(' ');
                        }
                        sb.append("\u001b[38;5;250m");
                        sb.append(']');
                        sb.append(' ');
                        sb.append(formattedPercentage);
                        sb.append('%');
                        sb.append(" (" + finished + "/" + total + ")");
                        i = ProgressBar.access$getShowElementsIfLessThan$p(this.this$0);
                        int n = snapshot.getGradingScheduled().size();
                        boolean bl = 1 <= n ? n < i : false;
                        if (bl) {
                            sb.append(" Remaining: [" + CollectionsKt.joinToString$default((Iterable)snapshot.getGradingScheduled(), null, null, null, (int)0, null, (Function1)print.1.INSTANCE, (int)31, null) + "]");
                        }
                        if (finished != ProgressBar.access$getLastFinished$p(this.this$0)) {
                            ProgressBar.access$getDeltaBuffer$p((ProgressBar)this.this$0)[ProgressBar.access$getBufferPos$p((ProgressBar)this.this$0)] = finished - ProgressBar.access$getLastFinished$p(this.this$0);
                            ProgressBar.access$getTimeBuffer$p((ProgressBar)this.this$0)[ProgressBar.access$getBufferPos$p((ProgressBar)this.this$0)] = Instant.now();
                            ProgressBar.access$setBufferPos$p(this.this$0, (ProgressBar.access$getBufferPos$p(this.this$0) + 1) % ProgressBar.access$getBufferSize$p(this.this$0));
                            ProgressBar.access$setLastFinished$p(this.this$0, finished);
                        }
                        Instant now = Instant.now();
                        Duration elapsed = Duration.between(ProgressBar.access$getGradingStart$p(this.this$0), now);
                        Duration estimatedTotal = ProgressBar.access$calculateVelocity(this.this$0).multipliedBy(total);
                        Duration estimatedLeft = estimatedTotal.minus(elapsed);
                        String[] stringArray = new String[7];
                        stringArray[0] = " ";
                        Intrinsics.checkNotNullExpressionValue((Object)elapsed, (String)"elapsed");
                        stringArray[1] = ProgressBarKt.getFormatted(elapsed);
                        stringArray[2] = " / ";
                        Intrinsics.checkNotNullExpressionValue((Object)estimatedTotal, (String)"estimatedTotal");
                        stringArray[3] = ProgressBarKt.getFormatted(estimatedTotal);
                        stringArray[4] = " (";
                        Intrinsics.checkNotNullExpressionValue((Object)estimatedLeft, (String)"estimatedLeft");
                        stringArray[5] = ProgressBarKt.getFormatted(estimatedLeft);
                        stringArray[6] = " remaining)";
                        StringsKt.append((StringBuilder)sb, (String[])stringArray);
                        sb.append(StringsKt.repeat((CharSequence)" ", (int)RangesKt.coerceAtLeast((int)(120 - sb.length()), (int)0)));
                        this.$out.print(sb.toString() + "\r");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull RubricCollector.Snapshot p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void clear(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.print(ProgressBarProvider.Companion.getCLEAR_TEXT());
    }

    public static final /* synthetic */ DecimalFormat access$getDecimalFormat$p(ProgressBar $this) {
        return $this.decimalFormat;
    }

    public static final /* synthetic */ ProgressBarProvider access$getProgressBarProvider$p(ProgressBar $this) {
        return $this.progressBarProvider;
    }

    public static final /* synthetic */ int access$getShowElementsIfLessThan$p(ProgressBar $this) {
        return $this.showElementsIfLessThan;
    }

    public static final /* synthetic */ int access$getLastFinished$p(ProgressBar $this) {
        return $this.lastFinished;
    }

    public static final /* synthetic */ int[] access$getDeltaBuffer$p(ProgressBar $this) {
        return $this.deltaBuffer;
    }

    public static final /* synthetic */ int access$getBufferPos$p(ProgressBar $this) {
        return $this.bufferPos;
    }

    public static final /* synthetic */ Instant[] access$getTimeBuffer$p(ProgressBar $this) {
        return $this.timeBuffer;
    }

    public static final /* synthetic */ void access$setBufferPos$p(ProgressBar $this, int n) {
        $this.bufferPos = n;
    }

    public static final /* synthetic */ int access$getBufferSize$p(ProgressBar $this) {
        return $this.bufferSize;
    }

    public static final /* synthetic */ void access$setLastFinished$p(ProgressBar $this, int n) {
        $this.lastFinished = n;
    }

    public static final /* synthetic */ Instant access$getGradingStart$p(ProgressBar $this) {
        return $this.gradingStart;
    }

    public static final /* synthetic */ Duration access$calculateVelocity(ProgressBar $this) {
        return $this.calculateVelocity();
    }
}

