/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sourcegrade.jagr.launcher.io.Resource;
import org.sourcegrade.jagr.launcher.io.ResourceContainer;
import org.sourcegrade.jagr.launcher.io.ResourceContainerInfo;
import org.sourcegrade.jagr.launcher.io.ResourceContainerInfoImpl;
import org.sourcegrade.jagr.launcher.io.ZipResourceIterator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/sourcegrade/jagr/launcher/io/ZipResourceContainer;", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainer;", "name", "", "input", "Ljava/io/InputStream;", "(Ljava/lang/String;Ljava/io/InputStream;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "info", "Lorg/sourcegrade/jagr/launcher/io/ResourceContainerInfo;", "(Lorg/sourcegrade/jagr/launcher/io/ResourceContainerInfo;Ljava/io/InputStream;)V", "getInfo", "()Lorg/sourcegrade/jagr/launcher/io/ResourceContainerInfo;", "iterator", "", "Lorg/sourcegrade/jagr/launcher/io/Resource;", "toString", "jagr-launcher"})
public final class ZipResourceContainer
implements ResourceContainer {
    @NotNull
    private final ResourceContainerInfo info;
    @NotNull
    private final InputStream input;

    public ZipResourceContainer(@NotNull ResourceContainerInfo info, @NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.info = info;
        this.input = input;
    }

    @Override
    @NotNull
    public ResourceContainerInfo getInfo() {
        return this.info;
    }

    public ZipResourceContainer(@NotNull String name, @NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(new ResourceContainerInfoImpl(name), input);
    }

    public ZipResourceContainer(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.name");
        String string = object;
        object = new FileInputStream(file);
        int n = 8192;
        this(string, (InputStream)(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n)));
    }

    @NotNull
    public Iterator<Resource> iterator() {
        return new ZipResourceIterator(new ZipInputStream(this.input));
    }

    @NotNull
    public String toString() {
        return this.getInfo().toString();
    }
}

