/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.env;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/sourcegrade/jagr/launcher/env/Executor;", "", "()V", "concurrency", "", "getConcurrency", "()I", "mode", "", "getMode", "()Ljava/lang/String;", "timeoutIndividual", "", "getTimeoutIndividual", "()J", "timeoutTotal", "getTimeoutTotal", "jagr-launcher"})
public final class Executor {
    @Comment(value="\nThe maximum amount of concurrency to use for grading.\nFor a given concurrency n, Jagr will ensure that a maximum of n threads or processes are used concurrently that actively run\nsubmission code.\n")
    private final int concurrency;
    @Comment(value="\nThe executor mode to use. The following options are available:\n- \"single\" ::\n  Runs every TestCycle consecutively in the main thread. This mode does not create any extra processes or threads for grading.\n\n- \"thread\" ::\n  Creates a separate thread for every TestCycle. This mode greatly speeds up the grading process, especially with a large\n  amount of submissions. The overhead of creating, managing and synchronizing threads is minimal compared to the performance\n  benefits. However, this mode has the danger of creating \"unkillable\" threads (e.g. from certain kinds of infinite loops)\n  which dramatically slow down the grading process through resource starvation of the host machine.\n\n  The maximum number of concurrent threads used for grading is defined by the option \"concurrency\".\n\n- \"process\" ::\n  Creates a separate process for every TestCycle. This mode has the most overhead, but is also the most defensive against\n  \"badly behaving\" code. A certain amount of sandboxing can be achieved in this mode, which is not possible in the other modes\n  such as \"thread\" or \"single\".\n\n  The maximum number of concurrent child process used for grading is defined by the option \"concurrency\".\n")
    @NotNull
    private final String mode;
    @Comment(value="\nThe grading thread's maximum permitted elapsed userTime in milliseconds since the last timeout before an\nAssertionFailedError is thrown. If a thread's userTime satisfies\n(userTime - lastTimeout) > individualTimeout,\nthe current userTime is stored for comparison later, and an AssertionFailedError is thrown to be caught by JUnit.\n")
    private final long timeoutIndividual;
    @Comment(value="\nThe grading thread's maximum permitted elapsed userTime in milliseconds (from thread start) before an\nAssertionFailedError is thrown. If a thread's userTime satisfies\n((userTime - lastTimeout) > individualTimeout) && (userTime > totalTimeout),\nan AssertionFailedError is thrown to be caught by JUnit. Note that lastTimeout is not reset in this case, and all further\ninvocations of checkTimeout() will result in an AssertionFailedError\n")
    private final long timeoutTotal;

    public Executor() {
        this.concurrency = 4;
        this.mode = "process";
        this.timeoutIndividual = 10000L;
        this.timeoutTotal = 150000L;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    @NotNull
    public final String getMode() {
        return this.mode;
    }

    public final long getTimeoutIndividual() {
        return this.timeoutIndividual;
    }

    public final long getTimeoutTotal() {
        return this.timeoutTotal;
    }
}

