/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.api.rubric;

import com.google.inject.Inject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.sourcegrade.jagr.api.rubric.Criterion;
import org.sourcegrade.jagr.api.rubric.GradeResult;
import org.sourcegrade.jagr.api.rubric.JUnitTestRef;
import org.sourcegrade.jagr.api.testing.TestCycle;

@FunctionalInterface
public interface Grader {
    public static TestAwareBuilder testAwareBuilder() {
        return FactoryProvider.factory.testAwareBuilder();
    }

    public static Grader descendingPriority(Grader ... graders) {
        return FactoryProvider.factory.descendingPriority(graders);
    }

    public GradeResult grade(TestCycle var1, Criterion var2);

    @ApiStatus.Internal
    public static final class FactoryProvider {
        @Inject
        private static Factory factory;
    }

    @ApiStatus.Internal
    public static interface Factory {
        public TestAwareBuilder testAwareBuilder();

        public Grader descendingPriority(Grader ... var1);
    }

    @ApiStatus.NonExtendable
    public static interface TestAwareBuilder
    extends Builder<TestAwareBuilder> {
        default public TestAwareBuilder requirePass(JUnitTestRef testRef) {
            return this.requirePass(testRef, null);
        }

        public TestAwareBuilder requirePass(JUnitTestRef var1, @Nullable String var2);

        default public TestAwareBuilder requireFail(JUnitTestRef testRef) {
            return this.requireFail(testRef, null);
        }

        public TestAwareBuilder requireFail(JUnitTestRef var1, @Nullable String var2);
    }

    @ApiStatus.NonExtendable
    public static interface Builder<B extends Builder<B>> {
        default public B pointsPassedMax() {
            return this.pointsPassed((ignored, criterion) -> GradeResult.ofMax(criterion));
        }

        default public B pointsPassedMin() {
            return this.pointsPassed((ignored, criterion) -> GradeResult.ofMin(criterion));
        }

        public B pointsPassed(@Nullable Grader var1);

        default public B pointsFailedMax() {
            return this.pointsFailed((ignored, criterion) -> GradeResult.ofMax(criterion));
        }

        default public B pointsFailedMin() {
            return this.pointsFailed((ignored, criterion) -> GradeResult.ofMin(criterion));
        }

        public B pointsFailed(@Nullable Grader var1);

        public B commentIfFailed(@Nullable String var1);

        public Grader build();
    }
}

