/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.api.rubric;

import com.google.inject.Inject;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.sourcegrade.jagr.api.rubric.Criterion;
import org.sourcegrade.jagr.api.rubric.Gradable;
import org.sourcegrade.jagr.api.rubric.PointRange;

@ApiStatus.NonExtendable
public interface GradeResult
extends PointRange {
    public static GradeResult ofCorrect(int points) {
        return FactoryProvider.factory.ofCorrect(points);
    }

    public static GradeResult ofNone() {
        return FactoryProvider.factory.ofNone();
    }

    public static GradeResult of(int minPoints, int maxPoints) {
        return FactoryProvider.factory.of(minPoints, maxPoints);
    }

    public static GradeResult of(int minPoints, int maxPoints, String comment) {
        return FactoryProvider.factory.of(minPoints, maxPoints, comment);
    }

    public static GradeResult of(PointRange pointRange) {
        return GradeResult.of(pointRange.getMinPoints(), pointRange.getMaxPoints());
    }

    public static GradeResult of(PointRange pointRange, String comment) {
        return GradeResult.of(pointRange.getMinPoints(), pointRange.getMaxPoints(), comment);
    }

    public static GradeResult of(GradeResult grade, GradeResult ... otherGrades) {
        return FactoryProvider.factory.of(grade, otherGrades);
    }

    public static GradeResult of(GradeResult grade, Iterable<? extends GradeResult> otherGrades) {
        return FactoryProvider.factory.of(grade, otherGrades);
    }

    public static GradeResult ofMax(Criterion criterion) {
        return FactoryProvider.factory.ofMax(criterion);
    }

    public static GradeResult ofMin(Criterion criterion) {
        return FactoryProvider.factory.ofMin(criterion);
    }

    public static GradeResult withComments(GradeResult grade, Iterable<String> comments) {
        return FactoryProvider.factory.withComments(grade, comments);
    }

    public static GradeResult clamped(GradeResult grade, Gradable<?> gradable) {
        return FactoryProvider.factory.clamped(grade, gradable);
    }

    @Override
    public int getMinPoints();

    @Override
    public int getMaxPoints();

    public List<String> getComments();

    default public GradeResult withoutComments() {
        if (this.getComments().isEmpty()) {
            return this;
        }
        return GradeResult.of(this);
    }

    @ApiStatus.Internal
    public static final class FactoryProvider {
        @Inject
        private static Factory factory;
    }

    @ApiStatus.Internal
    public static interface Factory {
        public GradeResult ofCorrect(int var1);

        public GradeResult ofNone();

        public GradeResult of(int var1, int var2);

        public GradeResult of(int var1, int var2, String var3);

        public GradeResult of(GradeResult var1, GradeResult ... var2);

        public GradeResult of(GradeResult var1, Iterable<? extends GradeResult> var2);

        public GradeResult ofMax(Criterion var1);

        public GradeResult ofMin(Criterion var1);

        public GradeResult withComments(GradeResult var1, Iterable<String> var2);

        public GradeResult clamped(GradeResult var1, Gradable<?> var2);
    }
}

