/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.collect.ImmutableMap;
import com.microsoft.z3.Native;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractEnumerationFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3EnumerationFormulaManager
extends AbstractEnumerationFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3EnumerationFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected AbstractEnumerationFormulaManager.EnumType declareEnumeration0(FormulaType.EnumerationFormulaType pType) {
        long symbol = Native.mkStringSymbol((long)this.z3context, (String)pType.getName());
        String[] elements = (String[])pType.getElements().toArray((Object[])new String[0]);
        long[] elementSymbols = new long[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            elementSymbols[i] = Native.mkStringSymbol((long)this.z3context, (String)elements[i]);
        }
        long[] constants = new long[pType.getElements().size()];
        long[] predicates = new long[pType.getElements().size()];
        long enumType = Native.mkEnumerationSort((long)this.z3context, (long)symbol, (int)elements.length, (long[])elementSymbols, (long[])constants, (long[])predicates);
        Native.incRef((long)this.z3context, (long)enumType);
        ImmutableMap.Builder constantsMapping = ImmutableMap.builder();
        for (int i = 0; i < elements.length; ++i) {
            long constantApp = Native.mkApp((long)this.z3context, (long)constants[i], (int)0, null);
            Native.incRef((long)this.z3context, (long)constantApp);
            constantsMapping.put((Object)elements[i], (Object)constantApp);
        }
        return new AbstractEnumerationFormulaManager.EnumType(pType, enumType, constantsMapping.buildOrThrow());
    }

    @Override
    protected Long equivalenceImpl(Long pF1, Long pF2) {
        return Native.mkEq((long)this.z3context, (long)pF1, (long)pF2);
    }
}

