/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.api.SimpleAPI;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.princess.PrincessArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessInterpolatingProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessTheoremProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessUFManager;

public final class PrincessSolverContext
extends AbstractSolverContext {
    private final PrincessFormulaManager manager;
    private final PrincessFormulaCreator creator;

    private PrincessSolverContext(PrincessFormulaManager manager, PrincessFormulaCreator creator) {
        super(manager);
        this.manager = manager;
        this.creator = creator;
    }

    public static SolverContext create(Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate pLogfileTemplate, int pRandomSeed, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) throws InvalidConfigurationException {
        PrincessEnvironment env = new PrincessEnvironment(config, pLogfileTemplate, pShutdownNotifier, pRandomSeed);
        PrincessFormulaCreator creator = new PrincessFormulaCreator(env);
        PrincessUFManager functionTheory = new PrincessUFManager(creator);
        PrincessBooleanFormulaManager booleanTheory = new PrincessBooleanFormulaManager(creator);
        PrincessIntegerFormulaManager integerTheory = new PrincessIntegerFormulaManager(creator, pNonLinearArithmetic);
        PrincessBitvectorFormulaManager bitvectorTheory = new PrincessBitvectorFormulaManager(creator, booleanTheory);
        PrincessArrayFormulaManager arrayTheory = new PrincessArrayFormulaManager(creator);
        PrincessQuantifiedFormulaManager quantifierTheory = new PrincessQuantifiedFormulaManager(creator);
        PrincessFormulaManager manager = new PrincessFormulaManager(creator, functionTheory, booleanTheory, integerTheory, bitvectorTheory, arrayTheory, quantifierTheory);
        return new PrincessSolverContext(manager, creator);
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        if (options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS)) {
            throw new UnsupportedOperationException("Princess does not support unsat core generation with assumptions yet");
        }
        return (PrincessTheoremProver)((PrincessEnvironment)this.creator.getEnv()).getNewProver(false, this.manager, this.creator, options);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> options) {
        return (PrincessInterpolatingProver)((PrincessEnvironment)this.creator.getEnv()).getNewProver(true, this.manager, this.creator, options);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        throw new UnsupportedOperationException("Princess does not support optimization");
    }

    @Override
    public String getVersion() {
        return "Princess " + SimpleAPI.version();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.PRINCESS;
    }

    @Override
    public void close() {
        ((PrincessEnvironment)this.creator.getEnv()).close();
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }
}

