/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtAbstractProver;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.Model;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.Symbol;
import org.sosy_lab.java_smt.solvers.opensmt.api.TemplateFunction;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorPTRef;

public class OpenSmtModel
extends AbstractModel<PTRef, SRef, Logic> {
    private final Logic osmtLogic;
    private final Model osmtModel;
    private final ImmutableList<Model.ValueAssignment> model;

    OpenSmtModel(OpenSmtAbstractProver<?> pProver, OpenSmtFormulaCreator pCreator, Collection<PTRef> pAssertedTerms) {
        super(pProver, pCreator);
        this.osmtLogic = (Logic)pCreator.getEnv();
        this.osmtModel = pProver.getOsmtSolver().getModel();
        HashMap<String, PTRef> userDeclarations = new HashMap<String, PTRef>();
        for (PTRef asserted : pAssertedTerms) {
            userDeclarations.putAll(this.creator.extractVariablesAndUFs(asserted, true));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PTRef term : userDeclarations.values()) {
            SymRef ref = this.osmtLogic.getSymRef(term);
            Symbol sym = this.osmtLogic.getSym(ref);
            int numArgs = sym.size() - 1;
            SRef sort = sym.rsort();
            if (this.osmtLogic.isArraySort(sort)) {
                throw new UnsupportedOperationException("OpenSMT does not support model generation when arrays are used");
            }
            if (numArgs == 0) {
                PTRef key = this.osmtLogic.mkVar(sort, this.osmtLogic.getSymName(ref));
                PTRef value = this.osmtModel.evaluate(key);
                builder.add((Object)new Model.ValueAssignment(pCreator.encapsulate(key), pCreator.encapsulate(value), pCreator.encapsulateBoolean(this.osmtLogic.mkEq(key, value)), this.osmtLogic.getSymName(ref), pCreator.convertValue(value), new ArrayList()));
                continue;
            }
            TemplateFunction tf = this.osmtModel.getDefinition(ref);
            for (List<PTRef> path : this.unfold(numArgs, tf.getBody())) {
                List<PTRef> args = path.subList(0, numArgs);
                PTRef key = this.osmtLogic.insertTerm(ref, new VectorPTRef(args));
                PTRef value = path.get(numArgs);
                builder.add((Object)new Model.ValueAssignment(pCreator.encapsulate(key), pCreator.encapsulate(value), pCreator.encapsulateBoolean(this.osmtLogic.mkEq(key, value)), this.osmtLogic.getSymName(ref), pCreator.convertValue(value), Lists.transform(args, pCreator::convertValue)));
            }
        }
        this.model = builder.build();
    }

    @Override
    public PTRef evalImpl(PTRef f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Map<String, PTRef> userDeclarations = this.creator.extractVariablesAndUFs(f, true);
        for (PTRef term : userDeclarations.values()) {
            SRef sort = this.osmtLogic.getSortRef(term);
            if (!this.osmtLogic.isArraySort(sort)) continue;
            throw new UnsupportedOperationException("OpenSMT does not support model generation when arrays are used");
        }
        return this.osmtModel.evaluate(f);
    }

    private List<List<PTRef>> unfold(int numArgs, PTRef body) {
        ArrayList<List<PTRef>> unwrapped = new ArrayList<List<PTRef>>();
        if (this.osmtLogic.isIte(body)) {
            PTRef sub0 = this.osmtLogic.getPterm(body).at(0);
            PTRef sub1 = this.osmtLogic.getPterm(body).at(1);
            PTRef sub2 = this.osmtLogic.getPterm(body).at(2);
            PTRef sub00 = this.osmtLogic.getPterm(sub0).at(0);
            PTRef sub01 = this.osmtLogic.getPterm(sub0).at(1);
            PTRef value = this.osmtLogic.isVar(sub00) ? sub01 : sub00;
            for (List<PTRef> nested : this.unfold(numArgs - 1, sub1)) {
                ArrayList<PTRef> prefixed = new ArrayList<PTRef>();
                prefixed.add(value);
                prefixed.addAll(nested);
                unwrapped.add(prefixed);
            }
            unwrapped.addAll(this.unfold(numArgs, sub2));
        }
        if (numArgs == 0) {
            ArrayList<PTRef> value = new ArrayList<PTRef>();
            value.add(body);
            unwrapped.add(value);
        }
        return unwrapped;
    }

    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        return this.model;
    }
}

