/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtAbstractProver;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtSolverContext;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorInt;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorPTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorVectorInt;

class OpenSmtInterpolatingProver
extends OpenSmtAbstractProver<Integer>
implements InterpolatingProverEnvironment<Integer> {
    private final Deque<Integer> trackedConstraints = new ArrayDeque<Integer>();

    OpenSmtInterpolatingProver(OpenSmtFormulaCreator pFormulaCreator, FormulaManager pMgr, ShutdownNotifier pShutdownNotifier, Set<SolverContext.ProverOptions> pOptions, OpenSmtSolverContext.OpenSMTOptions pSolverOptions) {
        super(pFormulaCreator, pMgr, pShutdownNotifier, OpenSmtInterpolatingProver.getConfigInstance(pOptions, pSolverOptions, true), pOptions);
        this.trackedConstraints.push(0);
    }

    @Override
    public Integer addConstraintImpl(PTRef f) throws InterruptedException {
        this.osmtSolver.insertFormula(f);
        Integer id = this.trackedConstraints.pop();
        this.trackedConstraints.push(id + 1);
        return id;
    }

    @Override
    protected void pushImpl() {
        super.pushImpl();
        this.trackedConstraints.push(this.trackedConstraints.peek());
    }

    @Override
    protected void popImpl() {
        this.trackedConstraints.pop();
        super.popImpl();
    }

    @Override
    public BooleanFormula getInterpolant(Collection<Integer> formulasOfA) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getAssertedConstraintIds().containsAll(formulasOfA), (Object)"interpolation can only be done over previously asserted formulas.");
        return this.creator.encapsulateBoolean(this.osmtSolver.getInterpolationContext().getSingleInterpolant(new VectorInt(formulasOfA)));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<Integer>> partitionedFormulas) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((!partitionedFormulas.isEmpty() ? 1 : 0) != 0, (Object)"Interpolation sequence must not be empty");
        ImmutableSet assertedConstraintIds = this.getAssertedConstraintIds();
        Preconditions.checkArgument((boolean)partitionedFormulas.stream().allMatch(arg_0 -> assertedConstraintIds.containsAll(arg_0)), (Object)"interpolation can only be done over previously asserted formulas.");
        VectorVectorInt partitions = new VectorVectorInt();
        for (int i = 1; i < partitionedFormulas.size(); ++i) {
            VectorInt prefix = new VectorInt();
            for (Collection collection : partitionedFormulas.subList(0, i)) {
                prefix.addAll(collection);
            }
            partitions.add(prefix);
        }
        VectorPTRef itps = this.osmtSolver.getInterpolationContext().getPathInterpolants(partitions);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (PTRef pTRef : itps) {
            result.add(this.creator.encapsulateBoolean(pTRef));
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<Integer>> partitionedFormulas, int[] startOfSubTree) {
        throw new UnsupportedOperationException("OpenSMT does not support tree interpolants");
    }

    @Override
    protected String getReasonFromSolverFeatures(boolean usesUFs, boolean usesIntegers, boolean usesReals, boolean usesArrays) {
        if (!this.creator.getLogic().doesLogicSupportInterpolation()) {
            return String.format("OpenSMT does not support interpolation for the specified logic %s.", new Object[]{this.creator.getLogic()});
        }
        return super.getReasonFromSolverFeatures(usesUFs, usesIntegers, usesReals, usesArrays);
    }
}

