/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtRationalFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtUFManager;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.Symbol;

class OpenSmtFormulaManager
extends AbstractFormulaManager<PTRef, SRef, Logic, SymRef> {
    private final OpenSmtFormulaCreator creator;
    private final Logic osmtLogic;

    OpenSmtFormulaManager(OpenSmtFormulaCreator pFormulaCreator, OpenSmtUFManager pFfmgr, OpenSmtBooleanFormulaManager pBfmgr, OpenSmtIntegerFormulaManager pIfmgr, OpenSmtRationalFormulaManager pRfmgr, OpenSmtArrayFormulaManager pAfmgr) {
        super(pFormulaCreator, pFfmgr, pBfmgr, pIfmgr, pRfmgr, null, null, null, pAfmgr, null, null, null);
        this.creator = pFormulaCreator;
        this.osmtLogic = (Logic)pFormulaCreator.getEnv();
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.creator.encapsulateBoolean(this.osmtLogic.parseFormula(pS));
    }

    @Override
    public Appender dumpFormula(final PTRef f) {
        assert (this.getFormulaCreator().getFormulaType(f) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                Map<String, PTRef> userDeclarations = OpenSmtFormulaManager.this.creator.extractVariablesAndUFs(f, true);
                for (PTRef term : userDeclarations.values()) {
                    SymRef ref = OpenSmtFormulaManager.this.osmtLogic.getSymRef(term);
                    Symbol sym = OpenSmtFormulaManager.this.osmtLogic.getSym(ref);
                    out.append("(declare-fun ").append(OpenSmtFormulaManager.this.osmtLogic.protectName(ref)).append(" (").append(Joiner.on((char)' ').join((Iterable)Lists.transform((List)sym.getArgTypes(), arg_0 -> ((Logic)OpenSmtFormulaManager.this.osmtLogic).printSort(arg_0)))).append(") ").append(OpenSmtFormulaManager.this.osmtLogic.printSort(sym.rsort())).append(")\n");
                }
                out.append("(assert ").append(OpenSmtFormulaManager.this.osmtLogic.dumpWithLets(f)).append(String.valueOf(')'));
            }
        };
    }
}

