/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5BooleanFormulaManager
extends AbstractBooleanFormulaManager<Long, Long, Long, Long> {
    private final long mathsatEnv;

    protected Mathsat5BooleanFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    @Override
    public Long makeVariableImpl(String pVar) {
        long boolType = (Long)this.getFormulaCreator().getBoolType();
        return (Long)this.getFormulaCreator().makeVariable(boolType, pVar);
    }

    @Override
    public Long makeBooleanImpl(boolean pValue) {
        long v = pValue ? Mathsat5NativeApi.msat_make_true(this.mathsatEnv) : Mathsat5NativeApi.msat_make_false(this.mathsatEnv);
        return v;
    }

    @Override
    public Long equivalence(Long f1, Long f2) {
        return Mathsat5NativeApi.msat_make_iff(this.mathsatEnv, f1, f2);
    }

    @Override
    public boolean isTrue(Long t) {
        return Mathsat5NativeApi.msat_term_is_true(this.mathsatEnv, t);
    }

    @Override
    public boolean isFalse(Long t) {
        return Mathsat5NativeApi.msat_term_is_false(this.mathsatEnv, t);
    }

    @Override
    public Long ifThenElse(Long cond, Long f1, Long f2) {
        if (this.isTrue(cond)) {
            return f1;
        }
        if (this.isFalse(cond)) {
            return f2;
        }
        if (f1.equals(f2)) {
            return f1;
        }
        if (this.isTrue(f1) && this.isFalse(f2)) {
            return cond;
        }
        if (this.isFalse(f1) && this.isTrue(f2)) {
            return this.not(cond);
        }
        long msatEnv = this.mathsatEnv;
        long f1Type = Mathsat5NativeApi.msat_term_get_type(f1);
        long f2Type = Mathsat5NativeApi.msat_term_get_type(f2);
        long t = !Mathsat5NativeApi.msat_is_bool_type(msatEnv, f1Type) || !Mathsat5NativeApi.msat_is_bool_type(msatEnv, f2Type) ? Mathsat5NativeApi.msat_make_term_ite(msatEnv, cond, f1, f2) : Mathsat5NativeApi.msat_make_and(msatEnv, Mathsat5NativeApi.msat_make_or(msatEnv, Mathsat5NativeApi.msat_make_not(msatEnv, cond), f1), Mathsat5NativeApi.msat_make_or(msatEnv, cond, f2));
        return t;
    }

    @Override
    public Long not(Long pBits) {
        return Mathsat5NativeApi.msat_make_not(this.mathsatEnv, pBits);
    }

    @Override
    public Long and(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_and(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long or(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_or(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long xor(Long pBits1, Long pBits2) {
        return this.not(Mathsat5NativeApi.msat_make_iff(this.mathsatEnv, pBits1, pBits2));
    }
}

