/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.errorprone.annotations.Immutable;
import io.github.cvc5.Term;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;

@Immutable
public class CVC5Formula
implements Formula {
    private final Term cvc5term;

    CVC5Formula(Term term) {
        this.cvc5term = term;
    }

    @Override
    public final String toString() {
        return this.cvc5term.toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CVC5Formula)) {
            return false;
        }
        return this.cvc5term.equals((Object)((CVC5Formula)o).cvc5term);
    }

    @Override
    public final int hashCode() {
        return Long.hashCode(this.cvc5term.getId());
    }

    final Term getTerm() {
        return this.cvc5term;
    }

    @Immutable
    static final class CVC5EnumerationFormula
    extends CVC5Formula
    implements EnumerationFormula {
        CVC5EnumerationFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5RegexFormula
    extends CVC5Formula
    implements RegexFormula {
        CVC5RegexFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5StringFormula
    extends CVC5Formula
    implements StringFormula {
        CVC5StringFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5BooleanFormula
    extends CVC5Formula
    implements BooleanFormula {
        CVC5BooleanFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5RationalFormula
    extends CVC5Formula
    implements NumeralFormula.RationalFormula {
        CVC5RationalFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5IntegerFormula
    extends CVC5Formula
    implements NumeralFormula.IntegerFormula {
        CVC5IntegerFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5FloatingPointRoundingModeFormula
    extends CVC5Formula
    implements FloatingPointRoundingModeFormula {
        CVC5FloatingPointRoundingModeFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5FloatingPointFormula
    extends CVC5Formula
    implements FloatingPointFormula {
        CVC5FloatingPointFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5BitvectorFormula
    extends CVC5Formula
    implements BitvectorFormula {
        CVC5BitvectorFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC5ArrayFormula<TI extends Formula, TE extends Formula>
    extends CVC5Formula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        CVC5ArrayFormula(Term pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pTerm);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

