/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import edu.stanford.CVC4.ArrayStoreAll;
import edu.stanford.CVC4.ArrayType;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Type;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

public class CVC4ArrayFormulaManager
extends AbstractArrayFormulaManager<Expr, Type, ExprManager, Expr> {
    private final ExprManager exprManager;

    public CVC4ArrayFormulaManager(CVC4FormulaCreator pFormulaCreator) {
        super(pFormulaCreator);
        this.exprManager = (ExprManager)pFormulaCreator.getEnv();
    }

    @Override
    protected Expr select(Expr pArray, Expr pIndex) {
        return this.exprManager.mkExpr(Kind.SELECT, pArray, pIndex);
    }

    @Override
    protected Expr store(Expr pArray, Expr pIndex, Expr pValue) {
        return this.exprManager.mkExpr(Kind.STORE, pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Expr internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        Type cvc4ArrayType = (Type)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return (Expr)this.getFormulaCreator().makeVariable(cvc4ArrayType, pName);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Expr internalMakeArray(FormulaType<TI> pIndexType, FormulaType<TE> pElementType, Expr defaultElement) {
        Type cvc4ArrayType = (Type)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return this.exprManager.mkConst(new ArrayStoreAll((ArrayType)cvc4ArrayType, defaultElement));
    }

    @Override
    protected Expr equivalence(Expr pArray1, Expr pArray2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pArray1, pArray2);
    }
}

