/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.basicimpl.CachingModel;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorModel;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

abstract class BoolectorAbstractProver<T>
extends AbstractProverWithAllSat<T> {
    private final AtomicBoolean isAnyStackAlive;
    private final long btor;
    private final BoolectorFormulaManager manager;
    private final BoolectorFormulaCreator creator;
    protected boolean wasLastSatCheckSat = false;
    private final BtorJNI.TerminationCallback terminationCallback;
    private final long terminationCallbackHelper;

    protected BoolectorAbstractProver(BoolectorFormulaManager manager, BoolectorFormulaCreator creator, long btor, ShutdownNotifier pShutdownNotifier, Set<SolverContext.ProverOptions> pOptions, AtomicBoolean pIsAnyStackAlive) {
        super(pOptions, manager.getBooleanFormulaManager(), pShutdownNotifier);
        this.manager = manager;
        this.creator = creator;
        this.btor = btor;
        this.terminationCallback = () -> ((ShutdownNotifier)this.shutdownNotifier).shouldShutdown();
        this.terminationCallbackHelper = this.addTerminationCallback();
        this.isAnyStackAlive = pIsAnyStackAlive;
        Preconditions.checkState((!this.isAnyStackAlive.getAndSet(true) ? 1 : 0) != 0, (Object)"Boolector does not support the usage of multiple solver stacks at the same time. Please close any existing solver stack.");
        BtorJNI.boolector_push((Long)manager.getEnvironment(), 1L);
    }

    @Override
    public void close() {
        if (!this.closed) {
            BtorJNI.boolector_free_termination(this.terminationCallbackHelper);
            BtorJNI.boolector_pop((Long)this.manager.getEnvironment(), this.size() + 1);
            Preconditions.checkState((boolean)this.isAnyStackAlive.getAndSet(false));
        }
        super.close();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        int result = BtorJNI.boolector_sat(this.btor);
        if (result == BtorJNI.BTOR_RESULT_SAT_get()) {
            this.wasLastSatCheckSat = true;
            return false;
        }
        if (result == BtorJNI.BTOR_RESULT_UNSAT_get()) {
            return true;
        }
        if (result == BtorJNI.BTOR_RESULT_UNKNOWN_get()) {
            if (BtorJNI.boolector_terminate(this.btor) == 0) {
                throw new SolverException("Boolector has encountered a problem or ran out of stack or heap memory, try increasing their sizes.");
            }
            throw new InterruptedException("Boolector was terminated via ShutdownManager.");
        }
        throw new SolverException("Boolector sat call returned " + result);
    }

    @Override
    protected void popImpl() {
        BtorJNI.boolector_pop((Long)this.manager.getEnvironment(), 1L);
    }

    @Override
    protected void pushImpl() throws InterruptedException {
        BtorJNI.boolector_push((Long)this.manager.getEnvironment(), 1L);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        for (BooleanFormula assumption : pAssumptions) {
            BtorJNI.boolector_assume(this.btor, BoolectorFormulaManager.getBtorTerm(assumption));
        }
        return this.isUnsat();
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.wasLastSatCheckSat, (Object)"Model computation failed. Are the pushed formulae satisfiable?");
        this.checkGenerateModels();
        return new CachingModel(this.getEvaluatorWithoutChecks());
    }

    @Override
    protected BoolectorModel getEvaluatorWithoutChecks() {
        return new BoolectorModel(this.btor, this.creator, this, Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo));
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        throw new UnsupportedOperationException("Unsat core is not supported by Boolector.");
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Unsat core with assumptions is not supported by Boolector.");
    }

    @Override
    protected @Nullable T addConstraintImpl(BooleanFormula constraint) throws InterruptedException {
        BtorJNI.boolector_assert((Long)this.manager.getEnvironment(), BoolectorFormulaManager.getBtorTerm(constraint));
        return null;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    private long addTerminationCallback() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        return BtorJNI.boolector_set_termination(this.btor, this.terminationCallback);
    }
}

