/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointNumber;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaDeclaration;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormula;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Kind;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Map_TermTerm;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.TermManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Int;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Term;

public class BitwuzlaFormulaCreator
extends FormulaCreator<Term, Sort, Void, BitwuzlaDeclaration> {
    private final TermManager termManager;
    private final Table<String, Sort, Term> formulaCache = HashBasedTable.create();
    private final Set<Term> variableCasts = new HashSet<Term>();

    protected BitwuzlaFormulaCreator(TermManager pTermManager) {
        super(null, pTermManager.mk_bool_sort(), null, null, null, null);
        this.termManager = pTermManager;
    }

    TermManager getTermManager() {
        return this.termManager;
    }

    @Override
    public Sort getBitvectorType(int bitwidth) {
        return this.termManager.mk_bv_sort(bitwidth);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Term pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType()) : "Unexpected formula type for BV formula: " + this.getFormulaType(pTerm);
        return new BitwuzlaFormula.BitwuzlaBitvectorFormula(pTerm);
    }

    @Override
    public Sort getFloatingPointType(FormulaType.FloatingPointType type) {
        return this.termManager.mk_fp_sort(type.getExponentSize(), type.getMantissaSize() + 1);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> FormulaType<TE> getArrayFormulaElementType(ArrayFormula<TI, TE> pArray) {
        return ((BitwuzlaFormula.BitwuzlaArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TI extends Formula, TE extends Formula> FormulaType<TI> getArrayFormulaIndexType(ArrayFormula<TI, TE> pArray) {
        return ((BitwuzlaFormula.BitwuzlaArrayFormula)pArray).getIndexType();
    }

    @Override
    public Sort getArrayType(Sort indexType, Sort elementType) {
        return this.termManager.mk_array_sort(indexType, elementType);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Term pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType()) : String.format("%s is no FP, but %s (%s)", pTerm, pTerm.sort(), this.getFormulaType(pTerm));
        return new BitwuzlaFormula.BitwuzlaFloatingPointFormula(pTerm);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(Term pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).isArrayType()) : "Unexpected formula type for array formula: " + this.getFormulaType(pTerm);
        return new BitwuzlaFormula.BitwuzlaArrayFormula<TI, TE>(pTerm, pIndexType, pElementType);
    }

    @Override
    public Term makeVariable(Sort pSort, String varName) {
        Term maybeFormula = (Term)this.formulaCache.get((Object)varName, (Object)pSort);
        if (maybeFormula != null) {
            return maybeFormula;
        }
        Term newVar = this.termManager.mk_const(pSort, varName);
        this.formulaCache.put((Object)varName, (Object)pSort, (Object)newVar);
        return newVar;
    }

    public Term makeBoundVariable(Term var) {
        String name = var.symbol();
        Sort sort = var.sort();
        Term newVar = this.termManager.mk_var(sort, name);
        return newVar;
    }

    public FormulaType<?> bitwuzlaSortToType(Sort pSort) {
        if (pSort.is_fp()) {
            int exponent = pSort.fp_exp_size();
            int mantissa = pSort.fp_sig_size() - 1;
            return FormulaType.getFloatingPointType(exponent, mantissa);
        }
        if (pSort.is_bv()) {
            return FormulaType.getBitvectorTypeWithSize(pSort.bv_size());
        }
        if (pSort.is_array()) {
            FormulaType<?> domainSort = this.bitwuzlaSortToType(pSort.array_index());
            FormulaType<?> rangeSort = this.bitwuzlaSortToType(pSort.array_element());
            return FormulaType.getArrayType(domainSort, rangeSort);
        }
        if (pSort.is_bool()) {
            return FormulaType.BooleanType;
        }
        if (pSort.is_rm()) {
            return FormulaType.FloatingPointRoundingModeType;
        }
        throw new UnsupportedOperationException("Could not find the JavaSMT type for sort" + pSort + ".");
    }

    private FunctionDeclarationKind getDeclarationKind(Term term) {
        Kind kind = term.kind();
        if (kind.equals(Kind.AND)) {
            return FunctionDeclarationKind.AND;
        }
        if (kind.equals(Kind.DISTINCT)) {
            return FunctionDeclarationKind.DISTINCT;
        }
        if (kind.equals(Kind.EQUAL)) {
            return FunctionDeclarationKind.EQ;
        }
        if (kind.equals(Kind.IFF)) {
            return FunctionDeclarationKind.IFF;
        }
        if (kind.equals(Kind.IMPLIES)) {
            return FunctionDeclarationKind.IMPLIES;
        }
        if (kind.equals(Kind.NOT)) {
            return FunctionDeclarationKind.NOT;
        }
        if (kind.equals(Kind.OR)) {
            return FunctionDeclarationKind.OR;
        }
        if (kind.equals(Kind.XOR)) {
            return FunctionDeclarationKind.XOR;
        }
        if (kind.equals(Kind.ITE)) {
            return FunctionDeclarationKind.ITE;
        }
        if (kind.equals(Kind.APPLY)) {
            return FunctionDeclarationKind.UF;
        }
        if (kind.equals(Kind.ARRAY_SELECT)) {
            return FunctionDeclarationKind.SELECT;
        }
        if (kind.equals(Kind.ARRAY_STORE)) {
            return FunctionDeclarationKind.STORE;
        }
        if (kind.equals(Kind.BV_ADD)) {
            return FunctionDeclarationKind.BV_ADD;
        }
        if (kind.equals(Kind.BV_AND)) {
            return FunctionDeclarationKind.BV_AND;
        }
        if (kind.equals(Kind.BV_ASHR)) {
            return FunctionDeclarationKind.BV_ASHR;
        }
        if (kind.equals(Kind.BV_CONCAT)) {
            return FunctionDeclarationKind.BV_CONCAT;
        }
        if (kind.equals(Kind.BV_MUL)) {
            return FunctionDeclarationKind.BV_MUL;
        }
        if (kind.equals(Kind.BV_NEG)) {
            return FunctionDeclarationKind.BV_NEG;
        }
        if (kind.equals(Kind.BV_NOT)) {
            return FunctionDeclarationKind.BV_NOT;
        }
        if (kind.equals(Kind.BV_OR)) {
            return FunctionDeclarationKind.BV_OR;
        }
        if (kind.equals(Kind.BV_SDIV)) {
            return FunctionDeclarationKind.BV_SDIV;
        }
        if (kind.equals(Kind.BV_SGE)) {
            return FunctionDeclarationKind.BV_SGE;
        }
        if (kind.equals(Kind.BV_SGT)) {
            return FunctionDeclarationKind.BV_SGT;
        }
        if (kind.equals(Kind.BV_SHL)) {
            return FunctionDeclarationKind.BV_SHL;
        }
        if (kind.equals(Kind.BV_SLE)) {
            return FunctionDeclarationKind.BV_SLE;
        }
        if (kind.equals(Kind.BV_SLT)) {
            return FunctionDeclarationKind.BV_SLT;
        }
        if (kind.equals(Kind.BV_SMOD)) {
            return FunctionDeclarationKind.BV_SMOD;
        }
        if (kind.equals(Kind.BV_SREM)) {
            return FunctionDeclarationKind.BV_SREM;
        }
        if (kind.equals(Kind.BV_SUB)) {
            return FunctionDeclarationKind.BV_SUB;
        }
        if (kind.equals(Kind.BV_UDIV)) {
            return FunctionDeclarationKind.BV_UDIV;
        }
        if (kind.equals(Kind.BV_UGE)) {
            return FunctionDeclarationKind.BV_UGE;
        }
        if (kind.equals(Kind.BV_UGT)) {
            return FunctionDeclarationKind.BV_UGT;
        }
        if (kind.equals(Kind.BV_ULE)) {
            return FunctionDeclarationKind.BV_ULE;
        }
        if (kind.equals(Kind.BV_ULT)) {
            return FunctionDeclarationKind.BV_ULT;
        }
        if (kind.equals(Kind.BV_UREM)) {
            return FunctionDeclarationKind.BV_UREM;
        }
        if (kind.equals(Kind.BV_EXTRACT)) {
            return FunctionDeclarationKind.BV_EXTRACT;
        }
        if (kind.equals(Kind.BV_SIGN_EXTEND)) {
            return FunctionDeclarationKind.BV_SIGN_EXTENSION;
        }
        if (kind.equals(Kind.BV_ZERO_EXTEND)) {
            return FunctionDeclarationKind.BV_ZERO_EXTENSION;
        }
        if (kind.equals(Kind.FP_ABS)) {
            return FunctionDeclarationKind.FP_ABS;
        }
        if (kind.equals(Kind.FP_ADD)) {
            return FunctionDeclarationKind.FP_ADD;
        }
        if (kind.equals(Kind.FP_DIV)) {
            return FunctionDeclarationKind.FP_DIV;
        }
        if (kind.equals(Kind.FP_EQUAL)) {
            return FunctionDeclarationKind.FP_EQ;
        }
        if (kind.equals(Kind.FP_GEQ)) {
            return FunctionDeclarationKind.FP_GE;
        }
        if (kind.equals(Kind.FP_GT)) {
            return FunctionDeclarationKind.FP_GT;
        }
        if (kind.equals(Kind.FP_IS_INF)) {
            return FunctionDeclarationKind.FP_IS_INF;
        }
        if (kind.equals(Kind.FP_IS_NAN)) {
            return FunctionDeclarationKind.FP_IS_NAN;
        }
        if (kind.equals(Kind.FP_IS_NEG)) {
            return FunctionDeclarationKind.FP_IS_NEGATIVE;
        }
        if (kind.equals(Kind.FP_IS_NORMAL)) {
            return FunctionDeclarationKind.FP_IS_NORMAL;
        }
        if (kind.equals(Kind.FP_IS_SUBNORMAL)) {
            return FunctionDeclarationKind.FP_IS_SUBNORMAL;
        }
        if (kind.equals(Kind.FP_IS_ZERO)) {
            return FunctionDeclarationKind.FP_IS_ZERO;
        }
        if (kind.equals(Kind.FP_LEQ)) {
            return FunctionDeclarationKind.FP_LE;
        }
        if (kind.equals(Kind.FP_LT)) {
            return FunctionDeclarationKind.FP_LT;
        }
        if (kind.equals(Kind.FP_MAX)) {
            return FunctionDeclarationKind.FP_MAX;
        }
        if (kind.equals(Kind.FP_MIN)) {
            return FunctionDeclarationKind.FP_MIN;
        }
        if (kind.equals(Kind.FP_MUL)) {
            return FunctionDeclarationKind.FP_MUL;
        }
        if (kind.equals(Kind.FP_NEG)) {
            return FunctionDeclarationKind.FP_NEG;
        }
        if (kind.equals(Kind.FP_RTI)) {
            return FunctionDeclarationKind.FP_ROUND_TO_INTEGRAL;
        }
        if (kind.equals(Kind.FP_SQRT)) {
            return FunctionDeclarationKind.FP_SQRT;
        }
        if (kind.equals(Kind.FP_SUB)) {
            return FunctionDeclarationKind.FP_SUB;
        }
        if (kind.equals(Kind.FP_TO_FP_FROM_BV)) {
            return FunctionDeclarationKind.BV_UCASTTO_FP;
        }
        if (kind.equals(Kind.FP_TO_FP_FROM_FP)) {
            return FunctionDeclarationKind.FP_CASTTO_FP;
        }
        if (kind.equals(Kind.FP_TO_FP_FROM_SBV)) {
            return FunctionDeclarationKind.BV_SCASTTO_FP;
        }
        if (kind.equals(Kind.FP_TO_FP_FROM_UBV)) {
            return FunctionDeclarationKind.BV_UCASTTO_FP;
        }
        if (kind.equals(Kind.FP_TO_SBV)) {
            return FunctionDeclarationKind.FP_CASTTO_SBV;
        }
        if (kind.equals(Kind.FP_TO_UBV)) {
            return FunctionDeclarationKind.FP_CASTTO_UBV;
        }
        if (kind.equals(Kind.BV_XOR)) {
            return FunctionDeclarationKind.BV_XOR;
        }
        throw new UnsupportedOperationException("Can not discern formula kind " + kind);
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Term pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm))) : String.format("Trying to encapsulate formula of type %s as %s", this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new BitwuzlaFormula.BitwuzlaBooleanFormula(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new BitwuzlaFormula.BitwuzlaArrayFormula(pTerm, arrFt.getIndexType(), arrFt.getElementType());
        }
        if (pType.isBitvectorType()) {
            return (T)new BitwuzlaFormula.BitwuzlaBitvectorFormula(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new BitwuzlaFormula.BitwuzlaFloatingPointFormula(pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)new BitwuzlaFormula.BitwuzlaFloatingPointRoundingModeFormula(pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in Bitwuzla");
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Sort sort = this.extractInfo(pFormula).sort();
        if (pFormula instanceof BitvectorFormula) {
            Preconditions.checkArgument((boolean)sort.is_bv(), (String)"BitvectorFormula with type missmatch: %s", pFormula);
            return FormulaType.getBitvectorTypeWithSize(sort.bv_size());
        }
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return FormulaType.getArrayType(arrayIndexType, arrayElementType);
        }
        if (pFormula instanceof FloatingPointFormula) {
            if (!sort.is_fp()) {
                throw new IllegalArgumentException("FloatingPointFormula with actual type " + sort + ": " + pFormula);
            }
            int exp = sort.fp_exp_size();
            int man = sort.fp_sig_size() - 1;
            return FormulaType.getFloatingPointType(exp, man);
        }
        if (sort.is_rm()) {
            return FormulaType.FloatingPointRoundingModeType;
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public FormulaType<?> getFormulaType(Term formula) {
        Sort pType = formula.sort();
        return this.bitwuzlaSortToType(pType);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Term f) throws UnsupportedOperationException {
        Kind kind = f.kind();
        if (f.is_value()) {
            return visitor.visitConstant(formula, this.convertValue(f));
        }
        if (f.is_const()) {
            String name = f.symbol();
            return visitor.visitFreeVariable(formula, name);
        }
        if (f.is_variable()) {
            String name = f.symbol();
            Sort sort = f.sort();
            Term originalVar = (Term)this.formulaCache.get((Object)name, (Object)sort);
            return visitor.visitBoundVariable((Formula)this.encapsulate(this.getFormulaType(originalVar), originalVar), 0);
        }
        if (kind.equals(Kind.EXISTS) || kind.equals(Kind.FORALL)) {
            Vector_Term children = f.children();
            int size = children.size();
            assert (size == 2);
            Term body = children.get(size - 1);
            ArrayList<Formula> freeEncVars = new ArrayList<Formula>();
            Term[] boundVars = new Term[size - 1];
            Term[] freeVars = new Term[size - 1];
            for (int i = 0; i < size - 1; ++i) {
                Term boundVar;
                boundVars[i] = boundVar = children.get(i);
                String name = boundVar.symbol();
                assert (name != null);
                Sort sort = boundVar.sort();
                Term freeVar = this.formulaCache.contains((Object)name, (Object)sort) ? (Term)this.formulaCache.get((Object)name, (Object)sort) : this.makeVariable(sort, name);
                freeVars[i] = freeVar;
                freeEncVars.add((Formula)this.encapsulate(this.getFormulaType(freeVar), freeVar));
            }
            Map_TermTerm map = new Map_TermTerm();
            for (int i = 0; i < boundVars.length; ++i) {
                map.put(boundVars[i], freeVars[i]);
            }
            body = this.termManager.substitute_term(body, map);
            QuantifiedFormulaManager.Quantifier quant = kind.equals(Kind.EXISTS) ? QuantifiedFormulaManager.Quantifier.EXISTS : QuantifiedFormulaManager.Quantifier.FORALL;
            return visitor.visitQuantifier((BooleanFormula)formula, quant, freeEncVars, this.encapsulateBoolean(body));
        }
        Vector_Term args = f.children();
        ImmutableList.Builder arguments = ImmutableList.builder();
        ImmutableList.Builder argumentTypes = ImmutableList.builder();
        String name = f.symbol();
        BitwuzlaDeclaration decl = null;
        for (int i = 0; i < args.size(); ++i) {
            Term argument = args.get(i);
            if (kind == Kind.APPLY && i == 0) {
                decl = BitwuzlaDeclaration.create(argument);
                name = argument.symbol();
                continue;
            }
            FormulaType<?> type = this.getFormulaType(argument);
            arguments.add(this.encapsulate(type, argument));
            argumentTypes.add(type);
        }
        if (name == null) {
            name = f.kind().toString();
        }
        if (decl == null) {
            decl = BitwuzlaDeclaration.create(f.kind());
        }
        if (f.num_indices() > 0L) {
            decl = BitwuzlaDeclaration.create(f);
        }
        return visitor.visitFunction(formula, (List<Formula>)arguments.build(), FunctionDeclarationImpl.of(name, this.getDeclarationKind(f), argumentTypes.build(), this.getFormulaType(f), decl));
    }

    @Override
    public Term callFunctionImpl(BitwuzlaDeclaration declaration, List<Term> args) {
        if (!declaration.isKind() && declaration.getTerm().num_indices() > 0L) {
            Term term = declaration.getTerm();
            Kind properKind = term.kind();
            return this.termManager.mk_term(properKind, new Vector_Term(args), term.indices());
        }
        if (!declaration.isKind() && declaration.getTerm().sort().is_fun()) {
            Vector_Term functionAndArgs = new Vector_Term();
            functionAndArgs.add(declaration.getTerm());
            functionAndArgs.addAll(args);
            return this.termManager.mk_term(Kind.APPLY, functionAndArgs, new Vector_Int());
        }
        assert (declaration.isKind());
        return this.termManager.mk_term(declaration.getKind(), new Vector_Term(args), new Vector_Int());
    }

    @Override
    public BitwuzlaDeclaration declareUFImpl(String name, Sort pReturnType, List<Sort> pArgTypes) {
        if (pArgTypes.isEmpty()) {
            throw new UnsupportedOperationException("Bitwuzla does not support 0 arity UFs.");
        }
        Sort functionSort = this.termManager.mk_fun_sort(new Vector_Sort(pArgTypes), pReturnType);
        Term maybeFormula = (Term)this.formulaCache.get((Object)name, (Object)functionSort);
        if (maybeFormula != null) {
            return BitwuzlaDeclaration.create(maybeFormula);
        }
        Term uf = this.termManager.mk_const(functionSort, name);
        this.formulaCache.put((Object)name, (Object)functionSort, (Object)uf);
        return BitwuzlaDeclaration.create(uf);
    }

    @Override
    protected BitwuzlaDeclaration getBooleanVarDeclarationImpl(Term pTerm) {
        Kind kind = pTerm.kind();
        assert (kind == Kind.APPLY || kind == Kind.CONSTANT) : kind.toString();
        if (kind == Kind.APPLY) {
            return BitwuzlaDeclaration.create(pTerm.get(0L));
        }
        return BitwuzlaDeclaration.create(pTerm);
    }

    @Override
    public Term extractInfo(Formula pT) {
        return BitwuzlaFormulaManager.getBitwuzlaTerm(pT);
    }

    @Override
    public BooleanFormula encapsulateBoolean(Term pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        return new BitwuzlaFormula.BitwuzlaBooleanFormula(pTerm);
    }

    protected Table<String, Sort, Term> getCache() {
        return this.formulaCache;
    }

    protected boolean formulaCacheContains(String variable) {
        return this.formulaCache.containsRow((Object)variable);
    }

    protected Optional<Term> getFormulaFromCache(String variable) {
        Iterator entrySetIter = this.formulaCache.row((Object)variable).entrySet().iterator();
        if (entrySetIter.hasNext()) {
            return Optional.of((Term)entrySetIter.next().getValue());
        }
        return Optional.empty();
    }

    @Override
    public Object convertValue(Term term) {
        Preconditions.checkArgument((boolean)term.is_value(), (String)"Term \"%s\" is not a value.", (Object)term);
        Sort sort = term.sort();
        if (sort.is_bool()) {
            return term.to_bool();
        }
        if (sort.is_rm()) {
            return term.to_rm();
        }
        if (sort.is_bv()) {
            return new BigInteger(term.to_bv(), 2);
        }
        if (sort.is_fp()) {
            int sizeExponent = sort.fp_exp_size();
            int sizeMantissa = sort.fp_sig_size() - 1;
            return FloatingPointNumber.of(term.to_bv(), sizeExponent, sizeMantissa);
        }
        throw new AssertionError((Object)"Unknown value type.");
    }

    public void addVariableCast(Term equal) {
        this.variableCasts.add(equal);
    }

    public Iterable<Term> getVariableCasts() {
        return this.variableCasts;
    }
}

