/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaDeclaration;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Kind;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.TermManager;

public class BitwuzlaBooleanFormulaManager
extends AbstractBooleanFormulaManager<Term, Sort, Void, BitwuzlaDeclaration> {
    private final TermManager termManager;
    private final Term pTrue;
    private final Term pFalse;

    protected BitwuzlaBooleanFormulaManager(BitwuzlaFormulaCreator pCreator) {
        super(pCreator);
        this.termManager = pCreator.getTermManager();
        this.pTrue = this.termManager.mk_true();
        this.pFalse = this.termManager.mk_false();
    }

    @Override
    protected Term makeVariableImpl(String pVar) {
        Sort boolType = (Sort)this.getFormulaCreator().getBoolType();
        return (Term)this.getFormulaCreator().makeVariable(boolType, pVar);
    }

    @Override
    protected Term makeBooleanImpl(boolean value) {
        return value ? this.pTrue : this.pFalse;
    }

    @Override
    protected Term not(Term pParam1) {
        if (this.isTrue(pParam1)) {
            return this.pFalse;
        }
        if (this.isFalse(pParam1)) {
            return this.pTrue;
        }
        if (pParam1.kind() == Kind.NOT) {
            return pParam1.get(0L);
        }
        return this.termManager.mk_term(Kind.NOT, pParam1);
    }

    @Override
    protected Term and(Term pParam1, Term pParam2) {
        if (this.isTrue(pParam1)) {
            return pParam2;
        }
        if (this.isTrue(pParam2)) {
            return pParam1;
        }
        if (this.isFalse(pParam1)) {
            return this.pFalse;
        }
        if (this.isFalse(pParam2)) {
            return this.pFalse;
        }
        if (pParam1.equals((Object)pParam2)) {
            return pParam1;
        }
        return this.termManager.mk_term(Kind.AND, pParam1, pParam2);
    }

    @Override
    protected Term or(Term pParam1, Term pParam2) {
        if (this.isTrue(pParam1)) {
            return this.pTrue;
        }
        if (this.isTrue(pParam2)) {
            return this.pTrue;
        }
        if (this.isFalse(pParam1)) {
            return pParam2;
        }
        if (this.isFalse(pParam2)) {
            return pParam1;
        }
        if (pParam1.equals((Object)pParam2)) {
            return pParam1;
        }
        return this.termManager.mk_term(Kind.OR, pParam1, pParam2);
    }

    @Override
    protected Term xor(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.XOR, pParam1, pParam2);
    }

    @Override
    protected Term equivalence(Term bits1, Term bits2) {
        return this.termManager.mk_term(Kind.IFF, bits1, bits2);
    }

    @Override
    protected boolean isTrue(Term bits) {
        return this.pTrue.equals((Object)bits);
    }

    @Override
    protected boolean isFalse(Term bits) {
        return this.pFalse.equals((Object)bits);
    }

    @Override
    protected Term ifThenElse(Term pCond, Term pF1, Term pF2) {
        if (this.isTrue(pCond)) {
            return pF1;
        }
        if (this.isFalse(pCond)) {
            return pF2;
        }
        if (pF1.equals((Object)pF2)) {
            return pF1;
        }
        if (this.isTrue(pF1) && this.isFalse(pF2)) {
            return pCond;
        }
        if (this.isFalse(pF1) && this.isTrue(pF2)) {
            return this.not(pCond);
        }
        return this.termManager.mk_term(Kind.ITE, pCond, pF1, pF2);
    }
}

