/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example.nqueens_user_propagator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.PropagatorBackend;
import org.sosy_lab.java_smt.basicimpl.AbstractUserPropagator;

public class NQueensEnumeratingPropagator
extends AbstractUserPropagator {
    protected final Deque<Integer> fixedCount = new ArrayDeque<Integer>();
    protected final Deque<BooleanFormula> fixedVariables = new ArrayDeque<BooleanFormula>();
    protected final Map<BooleanFormula, Boolean> currentModel = new HashMap<BooleanFormula, Boolean>();
    protected final Set<Map<BooleanFormula, Integer>> modelSet = new HashSet<Map<BooleanFormula, Integer>>();

    public int getNumOfSolutions() {
        return this.modelSet.size();
    }

    @Override
    public void onPush() {
        this.fixedCount.push(this.fixedVariables.size());
    }

    @Override
    public void onPop(int numPoppedLevel) {
        for (int i = 0; i < numPoppedLevel; ++i) {
            int lastCount = this.fixedCount.pop();
            while (this.fixedVariables.size() > lastCount) {
                this.currentModel.remove(this.fixedVariables.pop());
            }
        }
    }

    @Override
    public void onFinalCheck() {
        HashMap transformedModel = new HashMap(this.currentModel.size());
        this.currentModel.forEach((k, v) -> transformedModel.put(k, k.hashCode() * v.hashCode()));
        this.modelSet.add(transformedModel);
        this.getBackend().propagateConflict(this.fixedVariables.toArray(new BooleanFormula[0]));
    }

    @Override
    public void onKnownValue(BooleanFormula var, boolean value) {
        this.fixedVariables.push(var);
        this.currentModel.put(var, value);
    }

    @Override
    public void initializeWithBackend(PropagatorBackend backend) {
        super.initializeWithBackend(backend);
        backend.notifyOnFinalCheck();
        backend.notifyOnKnownValue();
    }
}

